/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.schemas.metadataquery;

import com.box.sdkgen.internal.NullableFieldTracker;
import com.box.sdkgen.internal.SerializableObject;
import com.box.sdkgen.schemas.metadataquery.MetadataQueryOrderByField;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonFilter(value="nullablePropertyFilter")
public class MetadataQuery
extends SerializableObject {
    protected final String from;
    protected String query;
    @JsonProperty(value="query_params")
    protected Map<String, Object> queryParams;
    @JsonProperty(value="ancestor_folder_id")
    protected final String ancestorFolderId;
    @JsonProperty(value="order_by")
    protected List<MetadataQueryOrderByField> orderBy;
    protected Long limit;
    protected String marker;
    protected List<String> fields;

    public MetadataQuery(@JsonProperty(value="from") String from, @JsonProperty(value="ancestor_folder_id") String ancestorFolderId) {
        this.from = from;
        this.ancestorFolderId = ancestorFolderId;
    }

    protected MetadataQuery(Builder builder) {
        this.from = builder.from;
        this.query = builder.query;
        this.queryParams = builder.queryParams;
        this.ancestorFolderId = builder.ancestorFolderId;
        this.orderBy = builder.orderBy;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.fields = builder.fields;
        this.markNullableFieldsAsSet(builder.getExplicitlySetNullableFields());
    }

    public String getFrom() {
        return this.from;
    }

    public String getQuery() {
        return this.query;
    }

    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    public String getAncestorFolderId() {
        return this.ancestorFolderId;
    }

    public List<MetadataQueryOrderByField> getOrderBy() {
        return this.orderBy;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getMarker() {
        return this.marker;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataQuery casted = (MetadataQuery)o;
        return Objects.equals(this.from, casted.from) && Objects.equals(this.query, casted.query) && Objects.equals(this.queryParams, casted.queryParams) && Objects.equals(this.ancestorFolderId, casted.ancestorFolderId) && Objects.equals(this.orderBy, casted.orderBy) && Objects.equals(this.limit, casted.limit) && Objects.equals(this.marker, casted.marker) && Objects.equals(this.fields, casted.fields);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.query, this.queryParams, this.ancestorFolderId, this.orderBy, this.limit, this.marker, this.fields);
    }

    public String toString() {
        return "MetadataQuery{from='" + this.from + '\'' + ", query='" + this.query + '\'' + ", queryParams='" + this.queryParams + '\'' + ", ancestorFolderId='" + this.ancestorFolderId + '\'' + ", orderBy='" + this.orderBy + '\'' + ", limit='" + this.limit + '\'' + ", marker='" + this.marker + '\'' + ", fields='" + this.fields + '\'' + "}";
    }

    public static class Builder
    extends NullableFieldTracker {
        protected final String from;
        protected String query;
        protected Map<String, Object> queryParams;
        protected final String ancestorFolderId;
        protected List<MetadataQueryOrderByField> orderBy;
        protected Long limit;
        protected String marker;
        protected List<String> fields;

        public Builder(String from, String ancestorFolderId) {
            this.from = from;
            this.ancestorFolderId = ancestorFolderId;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder queryParams(Map<String, Object> queryParams) {
            this.queryParams = queryParams;
            return this;
        }

        public Builder orderBy(List<MetadataQueryOrderByField> orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public MetadataQuery build() {
            return new MetadataQuery(this);
        }
    }
}

