/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.toolkit.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public abstract class MybatisAbstractSQL<T>
implements Serializable {
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String AND_NEW = ") \nAND (";
    private static final String OR_NEW = ") \nOR (";
    private static final Pattern pattern = Pattern.compile("[(|)|\\s]+");
    private final SQLCondition sql = new SQLCondition();

    public abstract T getSelf();

    public T WHERE(String conditions) {
        this.sql().where.add(conditions);
        this.sql().lastList = this.sql().where;
        return this.getSelf();
    }

    public T OR() {
        this.sql().lastList.add(OR);
        return this.getSelf();
    }

    public T OR_NEW() {
        this.sql().lastList.add(OR_NEW);
        return this.getSelf();
    }

    public T AND() {
        this.sql().lastList.add(AND);
        return this.getSelf();
    }

    public T SUPP(String supp) {
        this.sql().where.add(supp);
        return this.getSelf();
    }

    public T AND_NEW() {
        this.sql().lastList.add(AND_NEW);
        return this.getSelf();
    }

    public T GROUP_BY(String columns) {
        this.sql().groupBy.add(columns);
        return this.getSelf();
    }

    public T HAVING(String conditions) {
        this.sql().having.add(conditions);
        this.sql().lastList = this.sql().having;
        return this.getSelf();
    }

    public T ORDER_BY(String columns) {
        this.sql().orderBy.add(columns);
        return this.getSelf();
    }

    public T LAST(String last) {
        this.sql().last = last;
        return this.getSelf();
    }

    private SQLCondition sql() {
        return this.sql;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.sql().sql(sb);
        return sb.toString();
    }

    public boolean isEmptyOfWhere() {
        return CollectionUtils.isEmpty(this.sql().where);
    }

    private static class SQLCondition
    implements Serializable {
        final List<String> where = new ArrayList<String>();
        final List<String> having = new ArrayList<String>();
        final List<String> groupBy = new ArrayList<String>();
        final List<String> orderBy = new ArrayList<String>();
        final List<String> andOr = new ArrayList<String>();
        String last = null;
        List<String> lastList = new ArrayList<String>();

        public SQLCondition() {
            this.andOr.add(MybatisAbstractSQL.AND);
            this.andOr.add(MybatisAbstractSQL.OR);
            this.andOr.add(MybatisAbstractSQL.AND_NEW);
            this.andOr.add(MybatisAbstractSQL.OR_NEW);
        }

        private void sqlClause(SafeAppendable builder, String keyword, List<String> parts, String open, String close, String conjunction) {
            if (!(parts = this.clearNull(parts)).isEmpty()) {
                if (!builder.isEmpty()) {
                    builder.append("\n");
                }
                builder.append(keyword);
                builder.append(" ");
                builder.append(open);
                String last = "__";
                int n = parts.size();
                for (int i = 0; i < n; ++i) {
                    String part = parts.get(i);
                    if (i > 0) {
                        if (this.andOr.contains(part) || this.andOr.contains(last)) {
                            builder.append(part);
                            last = part;
                            continue;
                        }
                        if (!this.checkNest(part) && !this.checkNest(last)) {
                            builder.append(conjunction);
                        }
                    }
                    builder.append(part);
                }
                builder.append(close);
            }
        }

        private List<String> clearNull(List<String> parts) {
            ArrayList<String> temps = new ArrayList<String>();
            for (String part : parts) {
                if (StringUtils.isEmpty(part)) continue;
                temps.add(part);
            }
            return temps;
        }

        private String buildSQL(SafeAppendable builder) {
            this.sqlClause(builder, "WHERE", this.where, "(", ")", MybatisAbstractSQL.AND);
            this.sqlClause(builder, "GROUP BY", this.groupBy, "", "", ", ");
            this.sqlClause(builder, "HAVING", this.having, "(", ")", MybatisAbstractSQL.AND);
            this.sqlClause(builder, "ORDER BY", this.orderBy, "", "", ", ");
            if (StringUtils.isNotEmpty(this.last)) {
                builder.append(" ");
                builder.append(this.last);
            }
            return builder.toString();
        }

        public String sql(Appendable appendable) {
            return this.buildSQL(new SafeAppendable(appendable));
        }

        private boolean checkNest(String args) {
            return pattern.matcher(args).matches();
        }
    }

    private static class SafeAppendable
    implements Serializable {
        private final Appendable appendable;
        private boolean empty = true;

        public SafeAppendable(Appendable appendable) {
            this.appendable = appendable;
        }

        public SafeAppendable append(CharSequence charSequence) {
            try {
                if (this.empty && charSequence.length() > 0) {
                    this.empty = false;
                }
                this.appendable.append(charSequence);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

