/*
 * Copyright (c) 2014-2020 Baidu.com, Inc. All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.baidubce.services.bcc.model.securitygroup;

import com.baidubce.auth.BceCredentials;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcc.model.SecurityGroupRuleModel;
import com.baidubce.services.bcc.model.TagModel;
import com.fasterxml.jackson.annotation.JsonIgnore;

import java.util.List;

/**
 * The request for creating new SecurityGroup.
 */
public class CreateSecurityGroupRequest extends AbstractBceRequest {

    /**
     * An ASCII string whose length is less than 64.
     * The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * See more detail at
     * <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *     BCE API doc</a>
     */
    @JsonIgnore
    private String clientToken;

    /**
     * The name of SecurityGroup that will be created.
     */
    private String name;

    /**
     * the id specified in VPC, optional param
     */
    private String vpcId;

    /**
     * The optional parameter to describe the SecurityGroup that will be created.
     */
    private String desc;

    /**
     * The list of rules which define how the SecurityGroup works.
     */
    private List<SecurityGroupRuleModel> rules;

    /**
     * The list of tags.
     */
    private List<TagModel> tags;

    public String getClientToken() {
        return clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * Configure optional client token for the request. The request will be idempotent if client token is provided.
     * If the clientToken is not specified by the user, a random String generated by default algorithm will be used.
     * @param clientToken An ASCII string whose length is less than 64.
     *                    See more detail at
     *                    <a href = "https://bce.baidu.com/doc/BCC/API.html#.E5.B9.82.E7.AD.89.E6.80.A7">
     *                        BCE API doc</a>
     * @return CreateSecurityGroupRequest with specific clientToken
     */
    public CreateSecurityGroupRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateSecurityGroupRequest withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getVpcId() {
        return vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    /**
     * Configure name for the request.
     *
     * @param name The name of SecurityGroup that will be created.
     * @return CreateSecurityGroupRequest with name.
     */
    public CreateSecurityGroupRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * Configure desc for the request.
     *
     * @param desc The optional parameter to describe the SecurityGroup that will be created.
     * @return CreateSecurityGroupRequest with desc.
     */
    public CreateSecurityGroupRequest withDesc(String desc) {
        this.desc = desc;
        return this;
    }

    public List<SecurityGroupRuleModel> getRules() {
        return rules;
    }

    public void setRules(List<SecurityGroupRuleModel> rules) {
        this.rules = rules;
    }

    /**
     * Configure rules for the request.
     *
     * @param rules The list of rules which define how the SecurityGroup works.
     * @return CreateSecurityGroupRequest with rules.
     */
    public CreateSecurityGroupRequest withRules(List<SecurityGroupRuleModel> rules) {
        this.rules = rules;
        return this;
    }

    public List<TagModel> getTags() {
        return tags;
    }

    public void setTags(List<TagModel> tags) {
        this.tags = tags;
    }

    /**
     * Configure tags for the request.
     *
     * @param tags The list of tags which define how the SecurityGroup works.
     * @return CreateSecurityGroupRequest with tags.
     */
    public CreateSecurityGroupRequest withTags(List<TagModel> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Configure request credential for the request.
     *
     * @param credentials a valid instance of BceCredentials.
     * @return CreateSecurityGroupRequest with credentials.
     */
    @Override
    public CreateSecurityGroupRequest withRequestCredentials(BceCredentials credentials) {
        this.setRequestCredentials(credentials);
        return this;
    }
}
