/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.model.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.management.polling.PollerFactory;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.rest.ActivationResponse;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AcceptedImpl<InnerT, T>
implements Accepted<T> {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private final Response<Flux<ByteBuffer>> activationResponse;
    private byte[] responseBytes;
    private final SerializerAdapter serializerAdapter;
    private final HttpPipeline httpPipeline;
    private final Duration defaultPollInterval;
    private final Type pollResultType;
    private final Type finalResultType;
    private final Function<InnerT, T> wrapOperation;
    private final Context context;
    private PollerFlux<PollResult<InnerT>, InnerT> pollerFlux;
    private SyncPoller<Void, T> syncPoller;

    public AcceptedImpl(Response<Flux<ByteBuffer>> activationResponse, SerializerAdapter serializerAdapter, HttpPipeline httpPipeline, Duration defaultPollInterval, Type pollResultType, Type finalResultType, Function<InnerT, T> wrapOperation, Context context) {
        this.activationResponse = Objects.requireNonNull(activationResponse);
        this.serializerAdapter = Objects.requireNonNull(serializerAdapter);
        this.httpPipeline = Objects.requireNonNull(httpPipeline);
        this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval);
        this.pollResultType = Objects.requireNonNull(pollResultType);
        this.finalResultType = Objects.requireNonNull(finalResultType);
        this.wrapOperation = Objects.requireNonNull(wrapOperation);
        this.context = context;
    }

    @Override
    public ActivationResponse<T> getActivationResponse() {
        try {
            T value = this.wrapOperation.apply(this.serializerAdapter.deserialize(new String(this.getResponse(), StandardCharsets.UTF_8), this.finalResultType, SerializerEncoding.JSON));
            Duration retryAfter = AcceptedImpl.getRetryAfter(this.activationResponse.getHeaders());
            return new ActivationResponse<T>(this.activationResponse.getRequest(), this.activationResponse.getStatusCode(), this.activationResponse.getHeaders(), value, this.getActivationResponseStatus(), retryAfter);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Failed to deserialize activation response body", e));
        }
    }

    @Override
    public SyncPoller<Void, T> getSyncPoller() {
        if (this.syncPoller == null) {
            Function errorOperation = response -> {
                String errorMessage;
                ManagementError managementError = null;
                HttpResponseImpl errorResponse = null;
                PollResult.Error lroError = ((PollResult)response.getValue()).getError();
                if (((PollResult)response.getValue()).getError() != null) {
                    errorResponse = new HttpResponseImpl(lroError.getResponseStatusCode(), lroError.getResponseHeaders(), lroError.getResponseBody());
                    errorMessage = ((PollResult)response.getValue()).getError().getMessage();
                    String errorBody = ((PollResult)response.getValue()).getError().getResponseBody();
                    if (errorBody != null) {
                        try {
                            managementError = (ManagementError)this.serializerAdapter.deserialize(errorBody, ManagementError.class, SerializerEncoding.JSON);
                            if (managementError.getCode() == null || managementError.getMessage() == null) {
                                managementError = null;
                            }
                        }
                        catch (IOException | RuntimeException ioe) {
                            this.logger.logThrowableAsWarning((Throwable)ioe);
                        }
                    }
                } else {
                    errorMessage = "Long running operation failed.";
                }
                if (managementError == null) {
                    managementError = new ManagementError(response.getStatus().toString(), errorMessage);
                }
                return new ManagementException(errorMessage, (HttpResponse)errorResponse, managementError);
            };
            this.syncPoller = new SyncPollerImpl<InnerT, T>(this.getPollerFlux().getSyncPoller(), this.wrapOperation, errorOperation);
        }
        return this.syncPoller;
    }

    private PollerFlux<PollResult<InnerT>, InnerT> getPollerFlux() {
        if (this.pollerFlux == null) {
            Flux content = Flux.just((Object)ByteBuffer.wrap(this.getResponse()));
            SimpleResponse clonedResponse = new SimpleResponse(this.activationResponse, (Object)content);
            this.pollerFlux = PollerFactory.create((SerializerAdapter)this.serializerAdapter, (HttpPipeline)this.httpPipeline, (Type)this.pollResultType, (Type)this.finalResultType, (Duration)this.defaultPollInterval, (Mono)Mono.just((Object)clonedResponse), (Context)this.context);
        }
        return this.pollerFlux;
    }

    @Override
    public T getFinalResult() {
        return (T)this.getSyncPoller().getFinalResult();
    }

    private LongRunningOperationStatus getActivationResponseStatus() {
        String responseBody = new String(this.getResponse(), StandardCharsets.UTF_8);
        String provisioningState = null;
        if (!CoreUtils.isNullOrEmpty((CharSequence)responseBody)) {
            try {
                ResourceWithProvisioningState resource = (ResourceWithProvisioningState)this.serializerAdapter.deserialize(responseBody, ResourceWithProvisioningState.class, SerializerEncoding.JSON);
                provisioningState = resource != null ? resource.getProvisioningState() : null;
            }
            catch (IOException resource) {
                // empty catch block
            }
        }
        LongRunningOperationStatus status = LongRunningOperationStatus.IN_PROGRESS;
        if (!CoreUtils.isNullOrEmpty(provisioningState)) {
            status = AcceptedImpl.toLongRunningOperationStatus(provisioningState);
        } else {
            int statusCode = this.activationResponse.getStatusCode();
            if (statusCode == 200 || statusCode == 201 || statusCode == 204) {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
            }
        }
        return status;
    }

    private static LongRunningOperationStatus toLongRunningOperationStatus(String value) {
        if ("Succeeded".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
        }
        if ("Failed".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.FAILED;
        }
        if ("Canceled".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.USER_CANCELLED;
        }
        if ("InProgress".equalsIgnoreCase(value)) {
            return LongRunningOperationStatus.IN_PROGRESS;
        }
        return LongRunningOperationStatus.fromString((String)value, (boolean)false);
    }

    private static Duration getRetryAfter(HttpHeaders headers) {
        String value;
        if (headers != null && (value = headers.getValue("Retry-After")) != null) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        return null;
    }

    private byte[] getResponse() {
        if (this.responseBytes == null) {
            this.responseBytes = (byte[])FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)this.activationResponse.getValue())).block();
        }
        return this.responseBytes;
    }

    public static <T, InnerT> Accepted<T> newAccepted(ClientLogger logger, HttpPipeline httpPipeline, Duration pollInterval, Supplier<Response<Flux<ByteBuffer>>> activationOperation, Function<InnerT, T> convertOperation, Type innerType, Runnable preActivation, Context context) {
        Response<Flux<ByteBuffer>> activationResponse;
        if (preActivation != null) {
            preActivation.run();
        }
        if ((activationResponse = activationOperation.get()) == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException());
        }
        AcceptedImpl<InnerT, T> accepted = new AcceptedImpl<InnerT, T>(activationResponse, SerializerFactory.createDefaultManagementSerializerAdapter(), httpPipeline, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(pollInterval), innerType, innerType, convertOperation, context);
        return accepted;
    }

    public static <T extends HasInnerModel<InnerT>, InnerT> Accepted<T> newAccepted(ClientLogger logger, HttpPipeline httpPipeline, Duration pollInterval, Supplier<Response<Flux<ByteBuffer>>> activationOperation, Function<InnerT, T> convertOperation, Type innerType, Runnable preActivation, Consumer<InnerT> postActivation, Context context) {
        Response<Flux<ByteBuffer>> activationResponse;
        if (preActivation != null) {
            preActivation.run();
        }
        if ((activationResponse = activationOperation.get()) == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException());
        }
        AcceptedImpl<InnerT, T> accepted = new AcceptedImpl<InnerT, T>(activationResponse, SerializerFactory.createDefaultManagementSerializerAdapter(), httpPipeline, ResourceManagerUtils.InternalRuntimeContext.getDelayDuration(pollInterval), innerType, innerType, convertOperation, context);
        if (postActivation != null) {
            postActivation.accept(((HasInnerModel)accepted.getActivationResponse().getValue()).innerModel());
        }
        return accepted;
    }

    private static class SyncPollerImpl<InnerT, T>
    implements SyncPoller<Void, T> {
        private final SyncPoller<PollResult<InnerT>, InnerT> syncPoller;
        private final Function<InnerT, T> wrapOperation;
        private final Function<PollResponse<PollResult<InnerT>>, ManagementException> errorOperation;
        private T finalResult;
        private ManagementException exception;

        SyncPollerImpl(SyncPoller<PollResult<InnerT>, InnerT> syncPoller, Function<InnerT, T> wrapOperation, Function<PollResponse<PollResult<InnerT>>, ManagementException> errorOperation) {
            this.syncPoller = syncPoller;
            this.wrapOperation = wrapOperation;
            this.errorOperation = errorOperation;
        }

        public PollResponse<Void> poll() {
            return this.voidResponse(this.syncPoller.poll());
        }

        public PollResponse<Void> waitForCompletion() {
            return this.voidResponse(this.syncPoller.waitForCompletion());
        }

        public PollResponse<Void> waitForCompletion(Duration duration) {
            return this.voidResponse(this.syncPoller.waitForCompletion(duration));
        }

        public PollResponse<Void> waitUntil(LongRunningOperationStatus longRunningOperationStatus) {
            return this.voidResponse(this.syncPoller.waitUntil(longRunningOperationStatus));
        }

        public PollResponse<Void> waitUntil(Duration duration, LongRunningOperationStatus longRunningOperationStatus) {
            return this.voidResponse(this.syncPoller.waitUntil(duration, longRunningOperationStatus));
        }

        public T getFinalResult() {
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.finalResult == null) {
                PollResponse response;
                Object innerFinalResult = this.syncPoller.getFinalResult();
                if (innerFinalResult == null && ((response = this.syncPoller.poll()).getStatus() == LongRunningOperationStatus.FAILED || response.getStatus() == LongRunningOperationStatus.USER_CANCELLED)) {
                    this.exception = this.errorOperation.apply(response);
                    throw this.exception;
                }
                this.finalResult = this.wrapOperation.apply(innerFinalResult);
            }
            return this.finalResult;
        }

        public void cancelOperation() {
            this.syncPoller.cancelOperation();
        }

        private PollResponse<Void> voidResponse(PollResponse<PollResult<InnerT>> pollResponse) {
            return new PollResponse(pollResponse.getStatus(), null, pollResponse.getRetryAfter());
        }
    }

    private static class ResourceWithProvisioningState {
        @JsonProperty(value="properties")
        private Properties properties;

        private ResourceWithProvisioningState() {
        }

        private String getProvisioningState() {
            if (this.properties != null) {
                return this.properties.provisioningState;
            }
            return null;
        }

        private static class Properties {
            @JsonProperty(value="provisioningState")
            private String provisioningState;

            private Properties() {
            }
        }
    }

    private static class ProvisioningState {
        static final String IN_PROGRESS = "InProgress";
        static final String SUCCEEDED = "Succeeded";
        static final String FAILED = "Failed";
        static final String CANCELED = "Canceled";

        private ProvisioningState() {
        }
    }

    private static class HttpResponseImpl
    extends HttpResponse {
        private final int statusCode;
        private final byte[] responseBody;
        private final HttpHeaders httpHeaders;

        HttpResponseImpl(int statusCode, HttpHeaders httpHeaders, String responseBody) {
            super(null);
            this.statusCode = statusCode;
            this.httpHeaders = httpHeaders;
            this.responseBody = responseBody == null ? null : responseBody.getBytes(StandardCharsets.UTF_8);
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String s) {
            return this.httpHeaders.getValue(s);
        }

        public HttpHeaders getHeaders() {
            return this.httpHeaders;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.just((Object)ByteBuffer.wrap(this.responseBody));
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.just((Object)this.responseBody);
        }

        public Mono<String> getBodyAsString() {
            return Mono.just((Object)new String(this.responseBody, StandardCharsets.UTF_8));
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.just((Object)new String(this.responseBody, charset));
        }
    }
}

