/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.data.tables.models.TableEntity;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.function.Supplier;

public final class TableEntityAccessHelper {
    private static Supplier<TableEntity> creator;

    public static void setTableEntityCreator(Supplier<TableEntity> creator) {
        TableEntityAccessHelper.creator = creator;
    }

    public static TableEntity createEntity(Map<String, Object> properties) {
        if (creator == null) {
            new TableEntity("dummyPartitionKey", "dummyRowKey");
        }
        assert (creator != null);
        Object timestamp = properties.get("Timestamp");
        if (timestamp instanceof String) {
            try {
                properties.put("Timestamp", OffsetDateTime.parse((String)timestamp));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return creator.get().setProperties(properties);
    }

    private TableEntityAccessHelper() {
    }
}

