/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.appconfiguration.implementation.Conditions;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingHelper;
import com.azure.data.appconfiguration.implementation.Utility;
import com.azure.data.appconfiguration.implementation.models.KeyValue;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagFilter;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ConfigurationSettingDeserializationHelper {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    static final String FEATURE_FLAG_CONTENT_TYPE = "application/vnd.microsoft.appconfig.ff+json;charset=utf-8";
    static final String SECRET_REFERENCE_CONTENT_TYPE = "application/vnd.microsoft.appconfig.keyvaultref+json;charset=utf-8";

    public static PagedResponseBase<Object, ConfigurationSetting> toConfigurationSettingWithPagedResponse(PagedResponse<KeyValue> pagedResponse) {
        ArrayList settings = new ArrayList(pagedResponse.getValue().size());
        pagedResponse.getValue().forEach(keyValue -> settings.add(ConfigurationSettingDeserializationHelper.toConfigurationSetting(keyValue)));
        return new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), settings, (String)pagedResponse.getContinuationToken(), null);
    }

    public static Response<ConfigurationSetting> toConfigurationSettingWithResponse(Response<KeyValue> response) {
        return new SimpleResponse(response, (Object)ConfigurationSettingDeserializationHelper.toConfigurationSetting((KeyValue)response.getValue()));
    }

    public static ConfigurationSetting toConfigurationSetting(KeyValue keyValue) {
        if (keyValue == null) {
            return null;
        }
        String contentType = keyValue.getContentType();
        String key = keyValue.getKey();
        String value = keyValue.getValue();
        String label = keyValue.getLabel();
        String etag = keyValue.getEtag();
        Map<String, String> tags = keyValue.getTags();
        ConfigurationSetting setting = new ConfigurationSetting().setKey(key).setValue(value).setLabel(label).setContentType(contentType).setETag(etag).setTags(tags);
        ConfigurationSettingHelper.setLastModified(setting, keyValue.getLastModified());
        ConfigurationSettingHelper.setReadOnly(setting, keyValue.isLocked() != null && keyValue.isLocked() != false);
        try {
            if (FEATURE_FLAG_CONTENT_TYPE.equals(contentType)) {
                return ConfigurationSettingDeserializationHelper.subclassConfigurationSettingReflection(setting, ConfigurationSettingDeserializationHelper.parseFeatureFlagValue(setting.getValue())).setKey(setting.getKey()).setValue(setting.getValue()).setLabel(setting.getLabel()).setETag(setting.getETag()).setContentType(setting.getContentType()).setTags(setting.getTags());
            }
            if (SECRET_REFERENCE_CONTENT_TYPE.equals(contentType)) {
                return ConfigurationSettingDeserializationHelper.subclassConfigurationSettingReflection(setting, ConfigurationSettingDeserializationHelper.parseSecretReferenceFieldValue(setting.getKey(), setting.getValue())).setValue(value).setLabel(label).setETag(etag).setContentType(contentType).setTags(tags);
            }
            return setting;
        }
        catch (Exception exception) {
            throw LOGGER.logExceptionAsError(new RuntimeException("The setting is neither a 'FeatureFlagConfigurationSetting' nor 'SecretReferenceConfigurationSetting', return the setting as 'ConfigurationSetting'. Error: ", exception));
        }
    }

    private static <T extends ConfigurationSetting> ConfigurationSetting subclassConfigurationSettingReflection(ConfigurationSetting setting, T derivedClassSetting) {
        ConfigurationSettingHelper.setReadOnly(derivedClassSetting, setting.isReadOnly());
        ConfigurationSettingHelper.setLastModified(derivedClassSetting, setting.getLastModified());
        return derivedClassSetting;
    }

    public static FeatureFlagConfigurationSetting parseFeatureFlagValue(String valueInJson) {
        FeatureFlagConfigurationSetting featureFlagConfigurationSetting;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)valueInJson);
            try {
                featureFlagConfigurationSetting = ConfigurationSettingDeserializationHelper.getFeatureFlagPropertyValue(jsonReader);
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
                }
            }
            jsonReader.close();
        }
        return featureFlagConfigurationSetting;
    }

    public static SecretReferenceConfigurationSetting parseSecretReferenceFieldValue(String key, String value) {
        SecretReferenceConfigurationSetting secretReferenceConfigurationSetting;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)value);
            try {
                secretReferenceConfigurationSetting = (SecretReferenceConfigurationSetting)jsonReader.readObject(reader -> {
                    String secretId = null;
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        String fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("uri".equals(fieldName)) {
                            secretId = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    return new SecretReferenceConfigurationSetting(key, secretId);
                });
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(e));
                }
            }
            jsonReader.close();
        }
        return secretReferenceConfigurationSetting;
    }

    private static FeatureFlagConfigurationSetting getFeatureFlagPropertyValue(JsonReader jsonReader) throws IOException {
        return (FeatureFlagConfigurationSetting)jsonReader.readObject(reader -> {
            String featureId = null;
            boolean isEnabled = false;
            String description = null;
            String displayName = null;
            List<FeatureFlagFilter> clientFilters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    featureId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("display_name".equals(fieldName)) {
                    displayName = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    isEnabled = reader.getBoolean();
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    clientFilters = ConfigurationSettingDeserializationHelper.readConditions(reader).getFeatureFlagFilters();
                    continue;
                }
                reader.skipChildren();
            }
            return new FeatureFlagConfigurationSetting(featureId, isEnabled).setDescription(description).setDisplayName(displayName).setClientFilters(clientFilters);
        });
    }

    public static Conditions readConditions(JsonReader jsonReader) throws IOException {
        Conditions conditions = new Conditions();
        Map<String, Object> unknownConditions = conditions.getUnknownConditions();
        return (Conditions)jsonReader.readObject(reader -> {
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("client_filters".equals(fieldName)) {
                    conditions.setFeatureFlagFilters(reader.readArray(ConfigurationSettingDeserializationHelper::readClientFilter));
                    continue;
                }
                unknownConditions.put(fieldName, reader.readUntyped());
            }
            conditions.setUnknownConditions(unknownConditions);
            return conditions;
        });
    }

    public static FeatureFlagFilter readClientFilter(JsonReader jsonReader) throws IOException {
        return (FeatureFlagFilter)jsonReader.readObject(reader -> {
            String name = null;
            Map parameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = reader.readMap(JsonReader::readUntyped);
                    continue;
                }
                reader.skipChildren();
            }
            return new FeatureFlagFilter(name).setParameters(parameters);
        });
    }
}

