/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai;

import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.implementation.CompletionsUtils;
import com.azure.ai.openai.implementation.NonAzureOpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIClientImpl;
import com.azure.ai.openai.implementation.OpenAIServerSentEvents;
import com.azure.ai.openai.models.ChatCompletions;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.Completions;
import com.azure.ai.openai.models.CompletionsOptions;
import com.azure.ai.openai.models.Embeddings;
import com.azure.ai.openai.models.EmbeddingsOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.IterableStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

@ServiceClient(builder=OpenAIClientBuilder.class)
public final class OpenAIClient {
    private final OpenAIClientImpl serviceClient;
    private final NonAzureOpenAIClientImpl openAIServiceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEmbeddingsWithResponse(String deploymentId, BinaryData embeddingsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getEmbeddingsWithResponse(deploymentId, embeddingsOptions, requestOptions) : this.serviceClient.getEmbeddingsWithResponse(deploymentId, embeddingsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCompletionsWithResponse(String deploymentId, BinaryData completionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getCompletionsWithResponse(deploymentId, completionsOptions, requestOptions) : this.serviceClient.getCompletionsWithResponse(deploymentId, completionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getChatCompletionsWithResponse(String deploymentId, BinaryData chatCompletionsOptions, RequestOptions requestOptions) {
        return this.openAIServiceClient != null ? this.openAIServiceClient.getChatCompletionsWithResponse(deploymentId, chatCompletionsOptions, requestOptions) : this.serviceClient.getChatCompletionsWithResponse(deploymentId, chatCompletionsOptions, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Embeddings getEmbeddings(String deploymentId, EmbeddingsOptions embeddingsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Embeddings)((BinaryData)this.getEmbeddingsWithResponse(deploymentId, BinaryData.fromObject((Object)embeddingsOptions), requestOptions).getValue()).toObject(Embeddings.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentId, CompletionsOptions completionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (Completions)((BinaryData)this.getCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toObject(Completions.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Completions getCompletions(String deploymentId, String prompt) {
        return this.getCompletions(deploymentId, CompletionsUtils.defaultCompletionsOptions(prompt));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<Completions> getCompletionsStream(String deploymentId, CompletionsOptions completionsOptions) {
        completionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)completionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<Completions> completionsStream = new OpenAIServerSentEvents<Completions>((Flux<ByteBuffer>)responseStream, Completions.class);
        return new IterableStream(completionsStream.getEvents());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ChatCompletions getChatCompletions(String deploymentId, ChatCompletionsOptions chatCompletionsOptions) {
        RequestOptions requestOptions = new RequestOptions();
        return (ChatCompletions)((BinaryData)this.getChatCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toObject(ChatCompletions.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<ChatCompletions> getChatCompletionsStream(String deploymentId, ChatCompletionsOptions chatCompletionsOptions) {
        chatCompletionsOptions.setStream(true);
        RequestOptions requestOptions = new RequestOptions();
        Flux responseStream = ((BinaryData)this.getChatCompletionsWithResponse(deploymentId, BinaryData.fromObject((Object)chatCompletionsOptions), requestOptions).getValue()).toFluxByteBuffer();
        OpenAIServerSentEvents<ChatCompletions> chatCompletionsStream = new OpenAIServerSentEvents<ChatCompletions>((Flux<ByteBuffer>)responseStream, ChatCompletions.class);
        return new IterableStream(chatCompletionsStream.getEvents());
    }

    OpenAIClient(OpenAIClientImpl serviceClient) {
        this.serviceClient = serviceClient;
        this.openAIServiceClient = null;
    }

    OpenAIClient(NonAzureOpenAIClientImpl serviceClient) {
        this.serviceClient = null;
        this.openAIServiceClient = serviceClient;
    }
}

