//$Id: ExportingTransactionManagerImp.java,v 1.1.1.1 2006/08/29 10:01:11 guy Exp $
//$Log: ExportingTransactionManagerImp.java,v $
//Revision 1.1.1.1  2006/08/29 10:01:11  guy
//Import of 3.0 essentials edition.
//
//Revision 1.1.1.1  2006/04/29 08:55:38  guy
//Initial import.
//
//Revision 1.1.1.1  2006/03/29 13:21:30  guy
//Imported.
//
//Revision 1.1.1.1  2006/03/23 16:25:28  guy
//Imported.
//
//Revision 1.1.1.1  2006/03/22 13:46:54  guy
//Import.
//
//Revision 1.2  2006/03/15 10:31:56  guy
//Formatted code.
//
//Revision 1.1.1.1  2006/03/09 14:59:13  guy
//Imported 3.0 development into CVS repository.
//
//Revision 1.2  2004/10/12 13:03:49  guy
//Updated docs (changed Atomikos to Atomikos in many places).
//
//Revision 1.1  2002/02/03 10:03:46  guy
//Added SubTxThread support by adding Imp/Exp Tm instances.
//


              
/*
 * Copyright 2000-2008, Atomikos (http://www.atomikos.com) 
 *
 * This code ("Atomikos TransactionsEssentials"), by itself, 
 * is being distributed under the 
 * Apache License, Version 2.0 ("License"), a copy of which may be found at 
 * http://www.atomikos.com/licenses/apache-license-2.0.txt . 
 * You may not use this file except in compliance with the License. 
 *             
 * While the License grants certain patent license rights, 
 * those patent license rights only extend to the use of 
 * Atomikos TransactionsEssentials by itself. 
 *             
 * This code (Atomikos TransactionsEssentials) contains certain interfaces 
 * in package (namespace) com.atomikos.icatch
 * (including com.atomikos.icatch.Participant) which, if implemented, may
 * infringe one or more patents held by Atomikos.  
 * It should be appreciated that you may NOT implement such interfaces; 
 * licensing to implement these interfaces must be obtained separately from Atomikos.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  
 */
 
package com.atomikos.icatch.standalone;

import java.util.Stack;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.PropagationImp;
import com.atomikos.icatch.system.Configuration;

/**
 * 
 * 
 * An exporting TM implementation for the standalone. Needed to make the
 * SubTxThread mechanism work, NOT for propagation across VMs.
 */

class ExportingTransactionManagerImp implements ExportingTransactionManager
{
    /**
     * @see ExportingTransactionManager
     */

    public Propagation getPropagation () throws SysException
    {
        PropagationImp ret = null;

        CompositeTransaction ct = Configuration
                .getCompositeTransactionManager ().getCompositeTransaction ();
        Stack lineage = (Stack) ct.getLineage ().clone ();
        lineage.push ( ct );
        ret = new PropagationImp ( lineage, ct.isSerial (), ct
                .getTransactionControl ().getTimeout () );

        return ret;
    }

    /**
     * @see ExportingTransactionManager
     */

    public void addExtent ( Extent extent ) throws SysException
    {
        throw new SysException ( "Not implemented" );
    }

}
