/*
 * Decompiled with CFR 0.152.
 */
package com.arturmkrtchyan.kafka;

import java.nio.file.Path;

public class KafkaInstance {
    private final Path path;

    private KafkaInstance(Path instancePath) {
        this.path = instancePath;
    }

    protected static KafkaInstance fromPath(Path instancePath) {
        return new KafkaInstance(instancePath);
    }

    public Path getPath() {
        return this.path;
    }

    public Path getStartupScript() {
        return this.getPath().resolve("bin/kafka-server-start.sh");
    }

    public Path getShutdownScript() {
        return this.getPath().resolve("bin/kafka-server-stop.sh");
    }

    public Path getConfig() {
        return this.getPath().resolve("config/server.properties");
    }

    public Path getZookeeperStartupScript() {
        return this.getPath().resolve("bin/zookeeper-server-start.sh");
    }

    public Path getZookeeperShutdownScript() {
        return this.getPath().resolve("bin/zookeeper-server-stop.sh");
    }

    public Path getZookeeperConfig() {
        return this.getPath().resolve("config/zookeeper.properties");
    }
}

