/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import lombok.ast.ClassDeclaration;
import lombok.ast.ConstructorDeclaration;
import lombok.ast.Node;
import lombok.ast.NormalTypeBody;
import lombok.ast.TypeMember;

public class FragmentDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ValidFragment", (String)"Fragment not instantiatable", (String)"From the Fragment documentation:\n*Every* fragment must have an empty constructor, so it can be instantiated when restoring its activity's state. It is strongly recommended that subclasses do not have other constructors with parameters, since these constructors will not be called when the fragment is re-instantiated; instead, arguments can be supplied by the caller with `setArguments(Bundle)` and later retrieved by the Fragment with `getArguments()`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(FragmentDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/app/Fragment.html#Fragment()");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<String> applicableSuperClasses() {
        return Arrays.asList("android.app.Fragment", "android.support.v4.app.Fragment");
    }

    public void checkClass(@NonNull JavaContext context, @Nullable ClassDeclaration node, @NonNull Node declarationOrAnonymous, @NonNull JavaParser.ResolvedClass cls) {
        if (node == null) {
            return;
        }
        int flags = node.astModifiers().getEffectiveModifierFlags();
        if ((flags & 0x400) != 0) {
            return;
        }
        if ((flags & 1) == 0) {
            String message = String.format("This fragment class should be public (%1$s)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
            return;
        }
        if (cls.getContainingClass() != null && (flags & 8) == 0) {
            String message = String.format("This fragment inner class should be static (%1$s)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
            return;
        }
        boolean hasDefaultConstructor = false;
        boolean hasConstructor = false;
        NormalTypeBody body = node.astBody();
        if (body != null) {
            for (TypeMember member : body.astMembers()) {
                Location location;
                if (!(member instanceof ConstructorDeclaration)) continue;
                hasConstructor = true;
                ConstructorDeclaration constructor = (ConstructorDeclaration)member;
                if (constructor.astParameters().isEmpty()) {
                    if (constructor.astModifiers().isPublic()) {
                        hasDefaultConstructor = true;
                        continue;
                    }
                    location = context.getLocation((Node)constructor.astTypeName());
                    context.report(ISSUE, (Node)constructor, location, "The default constructor must be public");
                    hasDefaultConstructor = true;
                    continue;
                }
                location = context.getLocation((Node)constructor.astTypeName());
                String message = "Avoid non-default constructors in fragments: use a default constructor plus `Fragment#setArguments(Bundle)` instead";
                context.report(ISSUE, (Node)constructor, location, message);
            }
        }
        if (!hasDefaultConstructor && hasConstructor) {
            String message = String.format("This fragment should provide a default constructor (a public constructor with no arguments) (`%1$s`)", cls.getName());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message);
        }
    }
}

