/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

@Beta
public class ClassContext
extends Context {
    private final File mBinDir;
    private final ClassNode mClassNode;
    private final byte[] mBytes;
    private File mSourceFile;
    private String mSourceContents;
    private boolean mSearchedForSource;
    private final File mJarFile;
    private final boolean mFromLibrary;

    public ClassContext(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file, @Nullable File jarFile, @NonNull File binDir, @NonNull byte[] bytes, @NonNull ClassNode classNode, boolean fromLibrary, @Nullable String sourceContents) {
        super(driver, project, main, file);
        this.mJarFile = jarFile;
        this.mBinDir = binDir;
        this.mBytes = bytes;
        this.mClassNode = classNode;
        this.mFromLibrary = fromLibrary;
        this.mSourceContents = sourceContents;
    }

    @NonNull
    public byte[] getBytecode() {
        return this.mBytes;
    }

    @NonNull
    public ClassNode getClassNode() {
        return this.mClassNode;
    }

    @Nullable
    public File getJarFile() {
        return this.mJarFile;
    }

    public boolean isFromClassLibrary() {
        return this.mFromLibrary;
    }

    @Nullable
    public File getSourceFile() {
        block9: {
            if (this.mSourceFile != null || this.mSearchedForSource) break block9;
            this.mSearchedForSource = true;
            String source = this.mClassNode.sourceFile;
            if (source == null) {
                int index;
                source = this.file.getName();
                if (source.endsWith(".class")) {
                    source = source.substring(0, source.length() - ".class".length()) + ".java";
                }
                if ((index = source.indexOf(36)) != -1) {
                    source = source.substring(0, index) + ".java";
                }
            }
            if (source != null) {
                if (this.mJarFile != null) {
                    String relative = this.file.getParent() + File.separator + source;
                    List<File> sources = this.getProject().getJavaSourceFolders();
                    for (File dir : sources) {
                        File sourceFile = new File(dir, relative);
                        if (!sourceFile.exists()) continue;
                        this.mSourceFile = sourceFile;
                        break;
                    }
                } else {
                    String topPath = this.mBinDir.getPath();
                    String parentPath = this.file.getParentFile().getPath();
                    if (parentPath.startsWith(topPath)) {
                        int start = topPath.length() + 1;
                        String relative = start > parentPath.length() ? "" : parentPath.substring(start);
                        List<File> sources = this.getProject().getJavaSourceFolders();
                        for (File dir : sources) {
                            File sourceFile = new File(dir, relative + File.separator + source);
                            if (!sourceFile.exists()) continue;
                            this.mSourceFile = sourceFile;
                            break;
                        }
                    }
                }
            }
        }
        return this.mSourceFile;
    }

    @NonNull
    public String getSourceContents() {
        if (this.mSourceContents == null) {
            File sourceFile = this.getSourceFile();
            if (sourceFile != null) {
                this.mSourceContents = this.getClient().readFile(this.mSourceFile);
            }
            if (this.mSourceContents == null) {
                this.mSourceContents = "";
            }
        }
        return this.mSourceContents;
    }

    @Nullable
    public String getSourceContents(boolean read) {
        if (read) {
            return this.getSourceContents();
        }
        return this.mSourceContents;
    }

    @NonNull
    public Location getLocationForLine(int line, @Nullable String patternStart, @Nullable String patternEnd, @Nullable Location.SearchHints hints) {
        File sourceFile = this.getSourceFile();
        if (sourceFile != null) {
            if (line != -1) {
                return Location.create(sourceFile, this.getSourceContents(), line - 1, patternStart, patternEnd, hints);
            }
            return Location.create(sourceFile);
        }
        return Location.create(this.file);
    }

    @Override
    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (this.mDriver.isSuppressed(issue, this.mClassNode)) {
            return;
        }
        ClassNode curr = this.mClassNode;
        while (curr != null) {
            ClassNode prev = curr;
            if ((curr = this.mDriver.getOuterClassNode(curr)) == null) continue;
            if (prev.outerMethod != null) {
                List methods = curr.methods;
                for (Object m : methods) {
                    MethodNode method = (MethodNode)m;
                    if (!method.name.equals(prev.outerMethod) || !method.desc.equals(prev.outerMethodDesc)) continue;
                    if (method == null || !this.mDriver.isSuppressed(issue, this.mClassNode, method, null)) break;
                    return;
                }
            }
            if (!this.mDriver.isSuppressed(issue, curr)) continue;
            return;
        }
        super.report(issue, location, message, data);
    }

    public void report(@NonNull Issue issue, @Nullable MethodNode method, @Nullable AbstractInsnNode instruction, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (method != null && this.mDriver.isSuppressed(issue, this.mClassNode, method, instruction)) {
            return;
        }
        this.report(issue, location, message, data);
    }

    public void report(@NonNull Issue issue, @Nullable FieldNode field, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        if (field != null && this.mDriver.isSuppressed(issue, field)) {
            return;
        }
        this.report(issue, location, message, data);
    }

    public static int findLineNumber(@NonNull AbstractInsnNode node) {
        AbstractInsnNode curr;
        for (curr = node; curr != null; curr = curr.getPrevious()) {
            if (curr.getType() != 15) continue;
            return ((LineNumberNode)curr).line;
        }
        for (curr = node; curr != null; curr = curr.getNext()) {
            if (curr.getType() != 15) continue;
            return ((LineNumberNode)curr).line;
        }
        return -1;
    }

    public static int findLineNumber(@NonNull MethodNode node) {
        if (node.instructions != null && node.instructions.size() > 0) {
            return ClassContext.findLineNumber(node.instructions.get(0));
        }
        return -1;
    }

    public static int findLineNumber(@NonNull ClassNode node) {
        MethodNode firstMethod;
        if (node.methods != null && !node.methods.isEmpty() && (firstMethod = ClassContext.getFirstRealMethod(node)) != null) {
            return ClassContext.findLineNumber(firstMethod);
        }
        return -1;
    }

    @NonNull
    public Location getLocation(@NonNull ClassNode classNode) {
        String pattern = ClassContext.isAnonymousClass(classNode.name) ? classNode.superName : classNode.name;
        int index = pattern.lastIndexOf(36);
        if (index != -1) {
            pattern = pattern.substring(index + 1);
        }
        if ((index = pattern.lastIndexOf(47)) != -1) {
            pattern = pattern.substring(index + 1);
        }
        return this.getLocationForLine(ClassContext.findLineNumber(classNode), pattern, null, Location.SearchHints.create(Location.SearchDirection.BACKWARD).matchJavaSymbol());
    }

    @Nullable
    private static MethodNode getFirstRealMethod(@NonNull ClassNode classNode) {
        if (classNode.methods != null) {
            List methods = classNode.methods;
            for (Object m : methods) {
                MethodNode method = (MethodNode)m;
                if (method.name.charAt(0) == '<') continue;
                return method;
            }
            if (!classNode.methods.isEmpty()) {
                return (MethodNode)classNode.methods.get(0);
            }
        }
        return null;
    }

    @NonNull
    public Location getLocation(@NonNull MethodNode methodNode, @NonNull ClassNode classNode) {
        String pattern;
        Location.SearchDirection searchMode;
        if (methodNode.name.equals("<init>")) {
            searchMode = Location.SearchDirection.EOL_BACKWARD;
            pattern = ClassContext.isAnonymousClass(classNode.name) ? classNode.superName.substring(classNode.superName.lastIndexOf(47) + 1) : classNode.name.substring(classNode.name.lastIndexOf(36) + 1);
        } else {
            searchMode = Location.SearchDirection.BACKWARD;
            pattern = methodNode.name;
        }
        return this.getLocationForLine(ClassContext.findLineNumber(methodNode), pattern, null, Location.SearchHints.create(searchMode).matchJavaSymbol());
    }

    @NonNull
    public Location getLocation(@NonNull AbstractInsnNode instruction) {
        Location.SearchHints hints = Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol();
        String pattern = null;
        if (instruction instanceof MethodInsnNode) {
            MethodInsnNode call = (MethodInsnNode)instruction;
            if (call.name.equals("<init>")) {
                pattern = call.owner;
                hints = hints.matchConstructor();
            } else {
                pattern = call.name;
            }
            int index = pattern.lastIndexOf(36);
            if (index != -1) {
                pattern = pattern.substring(index + 1);
            }
            if ((index = pattern.lastIndexOf(47)) != -1) {
                pattern = pattern.substring(index + 1);
            }
        }
        int line = ClassContext.findLineNumber(instruction);
        return this.getLocationForLine(line, pattern, null, hints);
    }

    private static boolean isAnonymousClass(@NonNull String fqcn) {
        int lastIndex = fqcn.lastIndexOf(36);
        return lastIndex != -1 && lastIndex < fqcn.length() - 1 && Character.isDigit(fqcn.charAt(lastIndex + 1));
    }

    @NonNull
    public static String getFqcn(@NonNull String owner) {
        return owner.replace('/', '.').replace('$', '.');
    }

    public static String createSignature(String owner, String name, String desc) {
        StringBuilder sb = new StringBuilder(100);
        if (desc != null) {
            Type returnType = Type.getReturnType((String)desc);
            sb.append(ClassContext.getTypeString(returnType));
            sb.append(' ');
        }
        if (owner != null) {
            sb.append(ClassContext.getFqcn(owner));
        }
        if (name != null) {
            Type[] argumentTypes;
            sb.append('#');
            sb.append(name);
            if (desc != null && (argumentTypes = Type.getArgumentTypes((String)desc)) != null && argumentTypes.length > 0) {
                sb.append('(');
                boolean first = true;
                for (Type type : argumentTypes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(ClassContext.getTypeString(type));
                }
                sb.append(')');
            }
        }
        return sb.toString();
    }

    private static String getTypeString(Type type) {
        String s = type.getClassName();
        if (s.startsWith("java.lang.")) {
            s = s.substring("java.lang.".length());
        }
        return s;
    }

    @NonNull
    public static String getInternalName(@NonNull String fqcn) {
        if (fqcn.indexOf(46) == -1) {
            return fqcn;
        }
        StringBuilder sb = new StringBuilder(fqcn.length());
        String prev = null;
        for (String part : Splitter.on((char)'.').split((CharSequence)fqcn)) {
            if (prev != null && prev.length() > 0) {
                if (Character.isUpperCase(prev.charAt(0))) {
                    sb.append('$');
                } else {
                    sb.append('/');
                }
            }
            sb.append(part);
            prev = part;
        }
        return sb.toString();
    }
}

