/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.builder.internal.TemplateProcessor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class TestManifestGenerator {
    private static final String TEMPLATE = "AndroidManifest.template";
    private static final String PH_PACKAGE = "#PACKAGE#";
    private static final String PH_MIN_SDK_VERSION = "#MINSDKVERSION#";
    private static final String PH_TARGET_SDK_VERSION = "#TARGETSDKVERSION#";
    private static final String PH_TESTED_PACKAGE = "#TESTEDPACKAGE#";
    private static final String PH_TEST_RUNNER = "#TESTRUNNER#";
    private static final String PH_HANDLE_PROFILING = "#HANDLEPROFILING#";
    private static final String PH_FUNCTIONAL_TEST = "#FUNCTIONALTEST#";
    private final String mOutputFile;
    private final String mPackageName;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final String mTestedPackageName;
    private final String mTestRunnerName;
    private final boolean mHandleProfiling;
    private final boolean mFunctionalTest;

    public TestManifestGenerator(@NonNull String outputFile, @NonNull String packageName, int minSdkVersion, int targetSdkVersion, @NonNull String testedPackageName, @NonNull String testRunnerName, @NonNull Boolean handleProfiling, @NonNull Boolean functionalTest) {
        this.mOutputFile = outputFile;
        this.mPackageName = packageName;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion != -1 ? targetSdkVersion : minSdkVersion;
        this.mTestedPackageName = testedPackageName;
        this.mTestRunnerName = testRunnerName;
        this.mHandleProfiling = handleProfiling;
        this.mFunctionalTest = functionalTest;
    }

    public void generate() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PH_PACKAGE, this.mPackageName);
        map.put(PH_MIN_SDK_VERSION, Integer.toString(this.mMinSdkVersion));
        map.put(PH_TARGET_SDK_VERSION, Integer.toString(this.mTargetSdkVersion));
        map.put(PH_TESTED_PACKAGE, this.mTestedPackageName);
        map.put(PH_TEST_RUNNER, this.mTestRunnerName);
        map.put(PH_HANDLE_PROFILING, Boolean.toString(this.mHandleProfiling));
        map.put(PH_FUNCTIONAL_TEST, Boolean.toString(this.mFunctionalTest));
        TemplateProcessor processor = new TemplateProcessor(TestManifestGenerator.class.getResourceAsStream(TEMPLATE), map);
        processor.generate(new File(this.mOutputFile));
    }
}

