/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.SdkParser;
import com.android.builder.internal.FakeAndroidTarget;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.FullRevision;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PlatformSdkParser
implements SdkParser {
    private final String mPlatformRootFolder;
    private boolean mInitialized = false;
    private IAndroidTarget mTarget;
    private BuildToolInfo mBuildToolInfo;
    private File mHostTools;
    private File mZipAlign;
    private File mAdb;

    public PlatformSdkParser(@NonNull String sdkLocation) {
        this.mPlatformRootFolder = sdkLocation;
    }

    @Override
    public void initParser(@NonNull String target, @NonNull FullRevision buildToolRevision, @NonNull ILogger logger) {
        if (!this.mInitialized) {
            this.mTarget = new FakeAndroidTarget(this.mPlatformRootFolder, target);
            this.mBuildToolInfo = new BuildToolInfo(buildToolRevision, new File(this.mPlatformRootFolder), new File(this.getHostToolsFolder(), SdkConstants.FN_AAPT), new File(this.getHostToolsFolder(), SdkConstants.FN_AIDL), new File(this.mPlatformRootFolder, "prebuilts/sdk/tools/dx"), new File(this.mPlatformRootFolder, "prebuilts/sdk/tools/lib/dx.jar"), new File(this.getHostToolsFolder(), SdkConstants.FN_RENDERSCRIPT), new File(this.mPlatformRootFolder, "prebuilts/sdk/renderscript/include"), new File(this.mPlatformRootFolder, "prebuilts/sdk/renderscript/clang-include"), new File(this.getHostToolsFolder(), SdkConstants.FN_BCC_COMPAT), new File(this.getHostToolsFolder(), "arm-linux-androideabi-ld"), new File(this.getHostToolsFolder(), "i686-linux-android-ld"), new File(this.getHostToolsFolder(), "mipsel-linux-android-ld"));
            this.mInitialized = true;
        }
    }

    @Override
    @NonNull
    public IAndroidTarget getTarget() {
        if (!this.mInitialized) {
            throw new IllegalStateException("SdkParser was not initialized.");
        }
        return this.mTarget;
    }

    @Override
    @NonNull
    public BuildToolInfo getBuildTools() {
        if (!this.mInitialized) {
            throw new IllegalStateException("SdkParser was not initialized.");
        }
        return this.mBuildToolInfo;
    }

    @Override
    @NonNull
    public String getAnnotationsJar() {
        String host;
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            host = "darwin-x86";
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            host = "linux";
        } else {
            throw new IllegalStateException("Windows is not supported for platform development");
        }
        return this.mPlatformRootFolder + "/out/host/" + host + "/framework/annotations.jar";
    }

    @Override
    @Nullable
    public FullRevision getPlatformToolsRevision() {
        return new FullRevision(99);
    }

    @Override
    @NonNull
    public File getZipAlign() {
        if (this.mZipAlign == null) {
            this.mZipAlign = new File(this.getHostToolsFolder(), SdkConstants.FN_ZIPALIGN);
        }
        return this.mZipAlign;
    }

    @Override
    @NonNull
    public File getAdb() {
        if (this.mAdb == null) {
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mAdb = new File(this.mPlatformRootFolder, "out/host/darwin-x86/bin/adb");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mAdb = new File(this.mPlatformRootFolder, "out/host/linux-x86/bin/adb");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
        }
        return this.mAdb;
    }

    @Override
    @NonNull
    public List<File> getRepositories() {
        ArrayList repositories = Lists.newArrayList();
        repositories.add(new File(this.mPlatformRootFolder + "/prebuilts/sdk/m2repository"));
        return repositories;
    }

    private File getHostToolsFolder() {
        if (this.mHostTools == null) {
            File tools = new File(this.mPlatformRootFolder, "prebuilts/sdk/tools");
            if (SdkConstants.CURRENT_PLATFORM == 3) {
                this.mHostTools = new File(tools, "darwin");
            } else if (SdkConstants.CURRENT_PLATFORM == 1) {
                this.mHostTools = new File(tools, "linux");
            } else {
                throw new IllegalStateException("Windows is not supported for platform development");
            }
            if (!this.mHostTools.isDirectory()) {
                throw new IllegalStateException("Host tools folder missing: " + this.mHostTools.getAbsolutePath());
            }
        }
        return this.mHostTools;
    }
}

