/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.annotations.NonNull;
import com.android.builder.internal.InstallUtils;
import com.android.builder.internal.testing.SimpleTestCallable;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;

public class SimpleTestRunner
implements TestRunner {
    @Override
    public boolean runTests(@NonNull String projectName, @NonNull String variantName, @NonNull File testApk, @NonNull TestData testData, @NonNull List<? extends DeviceConnector> deviceList, int maxThreads, int timeout, @NonNull File resultsDir, @NonNull File coverageDir, @NonNull ILogger logger) throws TestException, TestRunner.NoAuthorizedDeviceFoundException, InterruptedException {
        int n;
        WaitableExecutor executor = new WaitableExecutor(maxThreads);
        boolean foundAtLeastOneAuthorizedDevice = false;
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() == IDevice.DeviceState.UNAUTHORIZED) continue;
            foundAtLeastOneAuthorizedDevice = true;
            if (!InstallUtils.checkDeviceApiLevel(deviceConnector, testData.getMinSdkVersion(), logger, projectName, variantName)) continue;
            File testedApk = null;
            if (!testData.isLibrary() && (testedApk = testData.getTestedApk(deviceConnector.getDensity(), deviceConnector.getAbis())) == null) {
                logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                continue;
            }
            executor.execute((Callable)new SimpleTestCallable(deviceConnector, projectName, variantName, testApk, testedApk, testData, resultsDir, coverageDir, timeout, logger));
        }
        if (!foundAtLeastOneAuthorizedDevice) {
            throw new TestRunner.NoAuthorizedDeviceFoundException();
        }
        List results = executor.waitForAllTasks();
        boolean bl = true;
        for (WaitableExecutor.TaskResult result : results) {
            if (result.value != null) {
                n &= ((Boolean)result.value).booleanValue();
                continue;
            }
            n = 0;
            logger.error(result.exception, null, new Object[0]);
        }
        return n != 0;
    }
}

