/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.trustedadvisor.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetOrganizationRecommendationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The Recommendation
     * </p>
     */
    private OrganizationRecommendation organizationRecommendation;

    /**
     * <p>
     * The Recommendation
     * </p>
     * 
     * @param organizationRecommendation
     *        The Recommendation
     */

    public void setOrganizationRecommendation(OrganizationRecommendation organizationRecommendation) {
        this.organizationRecommendation = organizationRecommendation;
    }

    /**
     * <p>
     * The Recommendation
     * </p>
     * 
     * @return The Recommendation
     */

    public OrganizationRecommendation getOrganizationRecommendation() {
        return this.organizationRecommendation;
    }

    /**
     * <p>
     * The Recommendation
     * </p>
     * 
     * @param organizationRecommendation
     *        The Recommendation
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetOrganizationRecommendationResult withOrganizationRecommendation(OrganizationRecommendation organizationRecommendation) {
        setOrganizationRecommendation(organizationRecommendation);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getOrganizationRecommendation() != null)
            sb.append("OrganizationRecommendation: ").append(getOrganizationRecommendation());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetOrganizationRecommendationResult == false)
            return false;
        GetOrganizationRecommendationResult other = (GetOrganizationRecommendationResult) obj;
        if (other.getOrganizationRecommendation() == null ^ this.getOrganizationRecommendation() == null)
            return false;
        if (other.getOrganizationRecommendation() != null && other.getOrganizationRecommendation().equals(this.getOrganizationRecommendation()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getOrganizationRecommendation() == null) ? 0 : getOrganizationRecommendation().hashCode());
        return hashCode;
    }

    @Override
    public GetOrganizationRecommendationResult clone() {
        try {
            return (GetOrganizationRecommendationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
