/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.stepfunctions.model.InspectionDataRequest;

@SdkInternalApi
public class InspectionDataRequestMarshaller {
    private static final MarshallingInfo<String> PROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protocol").build();
    private static final MarshallingInfo<String> METHOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("method").build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").build();
    private static final MarshallingInfo<String> HEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("headers").build();
    private static final MarshallingInfo<String> BODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("body").build();
    private static final InspectionDataRequestMarshaller instance = new InspectionDataRequestMarshaller();

    public static InspectionDataRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(InspectionDataRequest inspectionDataRequest, ProtocolMarshaller protocolMarshaller) {
        if (inspectionDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inspectionDataRequest.getProtocol(), PROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)inspectionDataRequest.getMethod(), METHOD_BINDING);
            protocolMarshaller.marshall((Object)inspectionDataRequest.getUrl(), URL_BINDING);
            protocolMarshaller.marshall((Object)inspectionDataRequest.getHeaders(), HEADERS_BINDING);
            protocolMarshaller.marshall((Object)inspectionDataRequest.getBody(), BODY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

