/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.Catcher;
import com.amazonaws.services.stepfunctions.builder.states.InputOutputResultPathBuilder;
import com.amazonaws.services.stepfunctions.builder.states.PathContainer;
import com.amazonaws.services.stepfunctions.builder.states.Retrier;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.TransitionStateBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.List;

public final class TaskState
extends TransitionState {
    @JsonProperty(value="Resource")
    private final String resource;
    @JsonUnwrapped
    private final PathContainer pathContainer;
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="TimeoutSeconds")
    private final Integer timeoutSeconds;
    @JsonProperty(value="HeartbeatSeconds")
    private final Integer heartbeatSeconds;
    @JsonUnwrapped
    private final Transition transition;
    @JsonProperty(value="Retry")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Retrier> retriers;
    @JsonProperty(value="Catch")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<Catcher> catchers;

    private TaskState(Builder builder) {
        this.resource = builder.resource;
        this.pathContainer = builder.pathContainer.build();
        this.comment = builder.comment;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.heartbeatSeconds = builder.heartbeatSeconds;
        this.transition = (Transition)builder.transition.build();
        this.retriers = Buildable.Utils.build(builder.retriers);
        this.catchers = Buildable.Utils.build(builder.catchers);
    }

    @Override
    public String getType() {
        return "Task";
    }

    public String getResource() {
        return this.resource;
    }

    @JsonIgnore
    public String getInputPath() {
        return this.pathContainer.getInputPath();
    }

    @JsonIgnore
    public String getResultPath() {
        return this.pathContainer.getResultPath();
    }

    @JsonIgnore
    public String getOutputPath() {
        return this.pathContainer.getOutputPath();
    }

    @Override
    public Transition getTransition() {
        return this.transition;
    }

    public String getComment() {
        return this.comment;
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Integer getHeartbeatSeconds() {
        return this.heartbeatSeconds;
    }

    public List<Retrier> getRetriers() {
        return this.retriers;
    }

    public List<Catcher> getCatchers() {
        return this.catchers;
    }

    @Override
    public <T> T accept(StateVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends TransitionStateBuilder
    implements InputOutputResultPathBuilder<Builder> {
        @JsonProperty(value="Resource")
        private String resource;
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="TimeoutSeconds")
        private Integer timeoutSeconds;
        @JsonProperty(value="HeartbeatSeconds")
        private Integer heartbeatSeconds;
        private Transition.Builder transition = Transition.NULL_BUILDER;
        private PathContainer.Builder pathContainer = PathContainer.builder();
        @JsonProperty(value="Retry")
        private final List<Retrier.Builder> retriers = new ArrayList<Retrier.Builder>();
        @JsonProperty(value="Catch")
        private final List<Catcher.Builder> catchers = new ArrayList<Catcher.Builder>();

        private Builder() {
        }

        public Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public Builder inputPath(String inputPath) {
            this.pathContainer.inputPath(inputPath);
            return this;
        }

        @Override
        public Builder resultPath(String resultPath) {
            this.pathContainer.resultPath(resultPath);
            return this;
        }

        @Override
        public Builder outputPath(String outputPath) {
            this.pathContainer.outputPath(outputPath);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public Builder heartbeatSeconds(Integer heartbeatSeconds) {
            this.heartbeatSeconds = heartbeatSeconds;
            return this;
        }

        @Override
        public Builder transition(Transition.Builder transition) {
            this.transition = transition;
            return this;
        }

        public Builder retriers(Retrier.Builder ... retrierBuilders) {
            for (Retrier.Builder retrierBuilder : retrierBuilders) {
                this.retrier(retrierBuilder);
            }
            return this;
        }

        public Builder retrier(Retrier.Builder retrierBuilder) {
            this.retriers.add(retrierBuilder);
            return this;
        }

        public Builder catchers(Catcher.Builder ... catcherBuilders) {
            for (Catcher.Builder catcherBuilder : catcherBuilders) {
                this.catcher(catcherBuilder);
            }
            return this;
        }

        public Builder catcher(Catcher.Builder catcherBuilder) {
            this.catchers.add(catcherBuilder);
            return this;
        }

        @Override
        public TaskState build() {
            return new TaskState(this);
        }
    }
}

