/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.Shipment;

public class ShipmentJsonMarshaller {
    private static ShipmentJsonMarshaller instance;

    public void marshall(Shipment shipment, StructuredJsonGenerator jsonGenerator) {
        if (shipment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (shipment.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(shipment.getStatus());
            }
            if (shipment.getTrackingNumber() != null) {
                jsonGenerator.writeFieldName("TrackingNumber").writeValue(shipment.getTrackingNumber());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ShipmentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ShipmentJsonMarshaller();
        }
        return instance;
    }
}

