/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.quicksight.model.S3BucketConfiguration;

@SdkInternalApi
public class S3BucketConfigurationMarshaller {
    private static final MarshallingInfo<String> BUCKETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketName").build();
    private static final MarshallingInfo<String> BUCKETPREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketPrefix").build();
    private static final MarshallingInfo<String> BUCKETREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BucketRegion").build();
    private static final S3BucketConfigurationMarshaller instance = new S3BucketConfigurationMarshaller();

    public static S3BucketConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3BucketConfiguration s3BucketConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3BucketConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3BucketConfiguration.getBucketName(), BUCKETNAME_BINDING);
            protocolMarshaller.marshall((Object)s3BucketConfiguration.getBucketPrefix(), BUCKETPREFIX_BINDING);
            protocolMarshaller.marshall((Object)s3BucketConfiguration.getBucketRegion(), BUCKETREGION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

