/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalizeruntime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeAsync;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeAsyncClientBuilder;
import com.amazonaws.services.personalizeruntime.AmazonPersonalizeRuntimeClient;
import com.amazonaws.services.personalizeruntime.model.GetActionRecommendationsRequest;
import com.amazonaws.services.personalizeruntime.model.GetActionRecommendationsResult;
import com.amazonaws.services.personalizeruntime.model.GetPersonalizedRankingRequest;
import com.amazonaws.services.personalizeruntime.model.GetPersonalizedRankingResult;
import com.amazonaws.services.personalizeruntime.model.GetRecommendationsRequest;
import com.amazonaws.services.personalizeruntime.model.GetRecommendationsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonPersonalizeRuntimeAsyncClient
extends AmazonPersonalizeRuntimeClient
implements AmazonPersonalizeRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonPersonalizeRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonPersonalizeRuntimeAsyncClientBuilder.standard();
    }

    AmazonPersonalizeRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonPersonalizeRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetActionRecommendationsResult> getActionRecommendationsAsync(GetActionRecommendationsRequest request) {
        return this.getActionRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetActionRecommendationsResult> getActionRecommendationsAsync(GetActionRecommendationsRequest request, final AsyncHandler<GetActionRecommendationsRequest, GetActionRecommendationsResult> asyncHandler) {
        final GetActionRecommendationsRequest finalRequest = (GetActionRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetActionRecommendationsResult>(){

            @Override
            public GetActionRecommendationsResult call() throws Exception {
                GetActionRecommendationsResult result = null;
                try {
                    result = AmazonPersonalizeRuntimeAsyncClient.this.executeGetActionRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPersonalizedRankingResult> getPersonalizedRankingAsync(GetPersonalizedRankingRequest request) {
        return this.getPersonalizedRankingAsync(request, null);
    }

    @Override
    public Future<GetPersonalizedRankingResult> getPersonalizedRankingAsync(GetPersonalizedRankingRequest request, final AsyncHandler<GetPersonalizedRankingRequest, GetPersonalizedRankingResult> asyncHandler) {
        final GetPersonalizedRankingRequest finalRequest = (GetPersonalizedRankingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPersonalizedRankingResult>(){

            @Override
            public GetPersonalizedRankingResult call() throws Exception {
                GetPersonalizedRankingResult result = null;
                try {
                    result = AmazonPersonalizeRuntimeAsyncClient.this.executeGetPersonalizedRanking(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request) {
        return this.getRecommendationsAsync(request, null);
    }

    @Override
    public Future<GetRecommendationsResult> getRecommendationsAsync(GetRecommendationsRequest request, final AsyncHandler<GetRecommendationsRequest, GetRecommendationsResult> asyncHandler) {
        final GetRecommendationsRequest finalRequest = (GetRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationsResult>(){

            @Override
            public GetRecommendationsResult call() throws Exception {
                GetRecommendationsResult result = null;
                try {
                    result = AmazonPersonalizeRuntimeAsyncClient.this.executeGetRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

