/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearchserverless.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.opensearchserverless.model.CollectionSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCollectionsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CollectionSummary> collectionSummaries;
    private String nextToken;

    public List<CollectionSummary> getCollectionSummaries() {
        return this.collectionSummaries;
    }

    public void setCollectionSummaries(Collection<CollectionSummary> collectionSummaries) {
        if (collectionSummaries == null) {
            this.collectionSummaries = null;
            return;
        }
        this.collectionSummaries = new ArrayList<CollectionSummary>(collectionSummaries);
    }

    public ListCollectionsResult withCollectionSummaries(CollectionSummary ... collectionSummaries) {
        if (this.collectionSummaries == null) {
            this.setCollectionSummaries(new ArrayList<CollectionSummary>(collectionSummaries.length));
        }
        for (CollectionSummary ele : collectionSummaries) {
            this.collectionSummaries.add(ele);
        }
        return this;
    }

    public ListCollectionsResult withCollectionSummaries(Collection<CollectionSummary> collectionSummaries) {
        this.setCollectionSummaries(collectionSummaries);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCollectionsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCollectionSummaries() != null) {
            sb.append("CollectionSummaries: ").append(this.getCollectionSummaries()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollectionsResult)) {
            return false;
        }
        ListCollectionsResult other = (ListCollectionsResult)obj;
        if (other.getCollectionSummaries() == null ^ this.getCollectionSummaries() == null) {
            return false;
        }
        if (other.getCollectionSummaries() != null && !other.getCollectionSummaries().equals(this.getCollectionSummaries())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCollectionSummaries() == null ? 0 : this.getCollectionSummaries().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCollectionsResult clone() {
        try {
            return (ListCollectionsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

