/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.RouteAnalysis;
import java.util.Date;

@SdkInternalApi
public class RouteAnalysisMarshaller {
    private static final MarshallingInfo<String> GLOBALNETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalNetworkId").build();
    private static final MarshallingInfo<String> OWNERACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerAccountId").build();
    private static final MarshallingInfo<String> ROUTEANALYSISID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RouteAnalysisId").build();
    private static final MarshallingInfo<Date> STARTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Source").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Destination").build();
    private static final MarshallingInfo<Boolean> INCLUDERETURNPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeReturnPath").build();
    private static final MarshallingInfo<Boolean> USEMIDDLEBOXES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UseMiddleboxes").build();
    private static final MarshallingInfo<StructuredPojo> FORWARDPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForwardPath").build();
    private static final MarshallingInfo<StructuredPojo> RETURNPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnPath").build();
    private static final RouteAnalysisMarshaller instance = new RouteAnalysisMarshaller();

    public static RouteAnalysisMarshaller getInstance() {
        return instance;
    }

    public void marshall(RouteAnalysis routeAnalysis, ProtocolMarshaller protocolMarshaller) {
        if (routeAnalysis == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)routeAnalysis.getGlobalNetworkId(), GLOBALNETWORKID_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getOwnerAccountId(), OWNERACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getRouteAnalysisId(), ROUTEANALYSISID_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getStartTimestamp(), STARTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getDestination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getIncludeReturnPath(), INCLUDERETURNPATH_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getUseMiddleboxes(), USEMIDDLEBOXES_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getForwardPath(), FORWARDPATH_BINDING);
            protocolMarshaller.marshall((Object)routeAnalysis.getReturnPath(), RETURNPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

