/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.networkmanager.model.CoreNetwork;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class CoreNetworkMarshaller {
    private static final MarshallingInfo<String> GLOBALNETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GlobalNetworkId").build();
    private static final MarshallingInfo<String> CORENETWORKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreNetworkId").build();
    private static final MarshallingInfo<String> CORENETWORKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoreNetworkArn").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<List> SEGMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Segments").build();
    private static final MarshallingInfo<List> EDGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Edges").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final CoreNetworkMarshaller instance = new CoreNetworkMarshaller();

    public static CoreNetworkMarshaller getInstance() {
        return instance;
    }

    public void marshall(CoreNetwork coreNetwork, ProtocolMarshaller protocolMarshaller) {
        if (coreNetwork == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)coreNetwork.getGlobalNetworkId(), GLOBALNETWORKID_BINDING);
            protocolMarshaller.marshall((Object)coreNetwork.getCoreNetworkId(), CORENETWORKID_BINDING);
            protocolMarshaller.marshall((Object)coreNetwork.getCoreNetworkArn(), CORENETWORKARN_BINDING);
            protocolMarshaller.marshall((Object)coreNetwork.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)coreNetwork.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)coreNetwork.getState(), STATE_BINDING);
            protocolMarshaller.marshall(coreNetwork.getSegments(), SEGMENTS_BINDING);
            protocolMarshaller.marshall(coreNetwork.getEdges(), EDGES_BINDING);
            protocolMarshaller.marshall(coreNetwork.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

