/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.neptunedata.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure containing the fast reset token used to initiate a fast reset.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/FastResetToken" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class FastResetToken implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by the
     * <code>performDatabaseReset</code> to reset the database.
     * </p>
     */
    private String token;

    /**
     * <p>
     * A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by the
     * <code>performDatabaseReset</code> to reset the database.
     * </p>
     * 
     * @param token
     *        A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by
     *        the <code>performDatabaseReset</code> to reset the database.
     */

    public void setToken(String token) {
        this.token = token;
    }

    /**
     * <p>
     * A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by the
     * <code>performDatabaseReset</code> to reset the database.
     * </p>
     * 
     * @return A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by
     *         the <code>performDatabaseReset</code> to reset the database.
     */

    public String getToken() {
        return this.token;
    }

    /**
     * <p>
     * A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by the
     * <code>performDatabaseReset</code> to reset the database.
     * </p>
     * 
     * @param token
     *        A UUID generated by the database in the <code>initiateDatabaseReset</code> action, and then consumed by
     *        the <code>performDatabaseReset</code> to reset the database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public FastResetToken withToken(String token) {
        setToken(token);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getToken() != null)
            sb.append("Token: ").append(getToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof FastResetToken == false)
            return false;
        FastResetToken other = (FastResetToken) obj;
        if (other.getToken() == null ^ this.getToken() == null)
            return false;
        if (other.getToken() != null && other.getToken().equals(this.getToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getToken() == null) ? 0 : getToken().hashCode());
        return hashCode;
    }

    @Override
    public FastResetToken clone() {
        try {
            return (FastResetToken) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.neptunedata.model.transform.FastResetTokenMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
