/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.marketplacecatalog.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Allows filtering on the <code>LastModifiedDate</code> of an offer.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/marketplace-catalog-2018-09-17/OfferLastModifiedDateFilter"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class OfferLastModifiedDateFilter implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     * </p>
     */
    private OfferLastModifiedDateFilterDateRange dateRange;

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     * </p>
     * 
     * @param dateRange
     *        Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     */

    public void setDateRange(OfferLastModifiedDateFilterDateRange dateRange) {
        this.dateRange = dateRange;
    }

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     * </p>
     * 
     * @return Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     */

    public OfferLastModifiedDateFilterDateRange getDateRange() {
        return this.dateRange;
    }

    /**
     * <p>
     * Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     * </p>
     * 
     * @param dateRange
     *        Allows filtering on the <code>LastModifiedDate</code> of an offer with date range as input.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public OfferLastModifiedDateFilter withDateRange(OfferLastModifiedDateFilterDateRange dateRange) {
        setDateRange(dateRange);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getDateRange() != null)
            sb.append("DateRange: ").append(getDateRange());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof OfferLastModifiedDateFilter == false)
            return false;
        OfferLastModifiedDateFilter other = (OfferLastModifiedDateFilter) obj;
        if (other.getDateRange() == null ^ this.getDateRange() == null)
            return false;
        if (other.getDateRange() != null && other.getDateRange().equals(this.getDateRange()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getDateRange() == null) ? 0 : getDateRange().hashCode());
        return hashCode;
    }

    @Override
    public OfferLastModifiedDateFilter clone() {
        try {
            return (OfferLastModifiedDateFilter) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.marketplacecatalog.model.transform.OfferLastModifiedDateFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
