/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lakeformation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lakeformation.model.PartitionObjects;
import java.util.List;

@SdkInternalApi
public class PartitionObjectsMarshaller {
    private static final MarshallingInfo<List> PARTITIONVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionValues").build();
    private static final MarshallingInfo<List> OBJECTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Objects").build();
    private static final PartitionObjectsMarshaller instance = new PartitionObjectsMarshaller();

    public static PartitionObjectsMarshaller getInstance() {
        return instance;
    }

    public void marshall(PartitionObjects partitionObjects, ProtocolMarshaller protocolMarshaller) {
        if (partitionObjects == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(partitionObjects.getPartitionValues(), PARTITIONVALUES_BINDING);
            protocolMarshaller.marshall(partitionObjects.getObjects(), OBJECTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

