/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kendra.model.TableCell;

@SdkInternalApi
public class TableCellMarshaller {
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Boolean> TOPANSWER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopAnswer").build();
    private static final MarshallingInfo<Boolean> HIGHLIGHTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Highlighted").build();
    private static final MarshallingInfo<Boolean> HEADER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Header").build();
    private static final TableCellMarshaller instance = new TableCellMarshaller();

    public static TableCellMarshaller getInstance() {
        return instance;
    }

    public void marshall(TableCell tableCell, ProtocolMarshaller protocolMarshaller) {
        if (tableCell == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tableCell.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall((Object)tableCell.getTopAnswer(), TOPANSWER_BINDING);
            protocolMarshaller.marshall((Object)tableCell.getHighlighted(), HIGHLIGHTED_BINDING);
            protocolMarshaller.marshall((Object)tableCell.getHeader(), HEADER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

