/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kendra.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kendra.model.CustomDocumentEnrichmentConfiguration;
import com.amazonaws.services.kendra.model.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutDocumentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String indexId;
    private String roleArn;
    private List<Document> documents;
    private CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

    public void setIndexId(String indexId) {
        this.indexId = indexId;
    }

    public String getIndexId() {
        return this.indexId;
    }

    public BatchPutDocumentRequest withIndexId(String indexId) {
        this.setIndexId(indexId);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public BatchPutDocumentRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(Collection<Document> documents) {
        if (documents == null) {
            this.documents = null;
            return;
        }
        this.documents = new ArrayList<Document>(documents);
    }

    public BatchPutDocumentRequest withDocuments(Document ... documents) {
        if (this.documents == null) {
            this.setDocuments(new ArrayList<Document>(documents.length));
        }
        for (Document ele : documents) {
            this.documents.add(ele);
        }
        return this;
    }

    public BatchPutDocumentRequest withDocuments(Collection<Document> documents) {
        this.setDocuments(documents);
        return this;
    }

    public void setCustomDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration) {
        this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration;
    }

    public CustomDocumentEnrichmentConfiguration getCustomDocumentEnrichmentConfiguration() {
        return this.customDocumentEnrichmentConfiguration;
    }

    public BatchPutDocumentRequest withCustomDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration) {
        this.setCustomDocumentEnrichmentConfiguration(customDocumentEnrichmentConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIndexId() != null) {
            sb.append("IndexId: ").append(this.getIndexId()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getDocuments() != null) {
            sb.append("Documents: ").append(this.getDocuments()).append(",");
        }
        if (this.getCustomDocumentEnrichmentConfiguration() != null) {
            sb.append("CustomDocumentEnrichmentConfiguration: ").append(this.getCustomDocumentEnrichmentConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentRequest)) {
            return false;
        }
        BatchPutDocumentRequest other = (BatchPutDocumentRequest)obj;
        if (other.getIndexId() == null ^ this.getIndexId() == null) {
            return false;
        }
        if (other.getIndexId() != null && !other.getIndexId().equals(this.getIndexId())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getDocuments() == null ^ this.getDocuments() == null) {
            return false;
        }
        if (other.getDocuments() != null && !other.getDocuments().equals(this.getDocuments())) {
            return false;
        }
        if (other.getCustomDocumentEnrichmentConfiguration() == null ^ this.getCustomDocumentEnrichmentConfiguration() == null) {
            return false;
        }
        return other.getCustomDocumentEnrichmentConfiguration() == null || other.getCustomDocumentEnrichmentConfiguration().equals(this.getCustomDocumentEnrichmentConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIndexId() == null ? 0 : this.getIndexId().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getDocuments() == null ? 0 : this.getDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getCustomDocumentEnrichmentConfiguration() == null ? 0 : this.getCustomDocumentEnrichmentConfiguration().hashCode());
        return hashCode;
    }

    public BatchPutDocumentRequest clone() {
        return (BatchPutDocumentRequest)super.clone();
    }
}

