/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotwireless.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotwireless-2020-11-22/CreateFuotaTask" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateFuotaTaskRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    private String name;

    private String description;

    private String clientRequestToken;

    private LoRaWANFuotaTask loRaWAN;

    private String firmwareUpdateImage;

    private String firmwareUpdateRole;

    private java.util.List<Tag> tags;

    private Integer redundancyPercent;

    private Integer fragmentSizeBytes;

    private Integer fragmentIntervalMS;

    /**
     * @param name
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return
     */

    public String getName() {
        return this.name;
    }

    /**
     * @param name
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * @param description
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * @param description
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * @param clientRequestToken
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * @return
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * @param clientRequestToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * @param loRaWAN
     */

    public void setLoRaWAN(LoRaWANFuotaTask loRaWAN) {
        this.loRaWAN = loRaWAN;
    }

    /**
     * @return
     */

    public LoRaWANFuotaTask getLoRaWAN() {
        return this.loRaWAN;
    }

    /**
     * @param loRaWAN
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withLoRaWAN(LoRaWANFuotaTask loRaWAN) {
        setLoRaWAN(loRaWAN);
        return this;
    }

    /**
     * @param firmwareUpdateImage
     */

    public void setFirmwareUpdateImage(String firmwareUpdateImage) {
        this.firmwareUpdateImage = firmwareUpdateImage;
    }

    /**
     * @return
     */

    public String getFirmwareUpdateImage() {
        return this.firmwareUpdateImage;
    }

    /**
     * @param firmwareUpdateImage
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withFirmwareUpdateImage(String firmwareUpdateImage) {
        setFirmwareUpdateImage(firmwareUpdateImage);
        return this;
    }

    /**
     * @param firmwareUpdateRole
     */

    public void setFirmwareUpdateRole(String firmwareUpdateRole) {
        this.firmwareUpdateRole = firmwareUpdateRole;
    }

    /**
     * @return
     */

    public String getFirmwareUpdateRole() {
        return this.firmwareUpdateRole;
    }

    /**
     * @param firmwareUpdateRole
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withFirmwareUpdateRole(String firmwareUpdateRole) {
        setFirmwareUpdateRole(firmwareUpdateRole);
        return this;
    }

    /**
     * @return
     */

    public java.util.List<Tag> getTags() {
        return tags;
    }

    /**
     * @param tags
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new java.util.ArrayList<Tag>(tags);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new java.util.ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * @param tags
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * @param redundancyPercent
     */

    public void setRedundancyPercent(Integer redundancyPercent) {
        this.redundancyPercent = redundancyPercent;
    }

    /**
     * @return
     */

    public Integer getRedundancyPercent() {
        return this.redundancyPercent;
    }

    /**
     * @param redundancyPercent
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withRedundancyPercent(Integer redundancyPercent) {
        setRedundancyPercent(redundancyPercent);
        return this;
    }

    /**
     * @param fragmentSizeBytes
     */

    public void setFragmentSizeBytes(Integer fragmentSizeBytes) {
        this.fragmentSizeBytes = fragmentSizeBytes;
    }

    /**
     * @return
     */

    public Integer getFragmentSizeBytes() {
        return this.fragmentSizeBytes;
    }

    /**
     * @param fragmentSizeBytes
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withFragmentSizeBytes(Integer fragmentSizeBytes) {
        setFragmentSizeBytes(fragmentSizeBytes);
        return this;
    }

    /**
     * @param fragmentIntervalMS
     */

    public void setFragmentIntervalMS(Integer fragmentIntervalMS) {
        this.fragmentIntervalMS = fragmentIntervalMS;
    }

    /**
     * @return
     */

    public Integer getFragmentIntervalMS() {
        return this.fragmentIntervalMS;
    }

    /**
     * @param fragmentIntervalMS
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateFuotaTaskRequest withFragmentIntervalMS(Integer fragmentIntervalMS) {
        setFragmentIntervalMS(fragmentIntervalMS);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken()).append(",");
        if (getLoRaWAN() != null)
            sb.append("LoRaWAN: ").append(getLoRaWAN()).append(",");
        if (getFirmwareUpdateImage() != null)
            sb.append("FirmwareUpdateImage: ").append(getFirmwareUpdateImage()).append(",");
        if (getFirmwareUpdateRole() != null)
            sb.append("FirmwareUpdateRole: ").append(getFirmwareUpdateRole()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getRedundancyPercent() != null)
            sb.append("RedundancyPercent: ").append(getRedundancyPercent()).append(",");
        if (getFragmentSizeBytes() != null)
            sb.append("FragmentSizeBytes: ").append(getFragmentSizeBytes()).append(",");
        if (getFragmentIntervalMS() != null)
            sb.append("FragmentIntervalMS: ").append(getFragmentIntervalMS());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateFuotaTaskRequest == false)
            return false;
        CreateFuotaTaskRequest other = (CreateFuotaTaskRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        if (other.getLoRaWAN() == null ^ this.getLoRaWAN() == null)
            return false;
        if (other.getLoRaWAN() != null && other.getLoRaWAN().equals(this.getLoRaWAN()) == false)
            return false;
        if (other.getFirmwareUpdateImage() == null ^ this.getFirmwareUpdateImage() == null)
            return false;
        if (other.getFirmwareUpdateImage() != null && other.getFirmwareUpdateImage().equals(this.getFirmwareUpdateImage()) == false)
            return false;
        if (other.getFirmwareUpdateRole() == null ^ this.getFirmwareUpdateRole() == null)
            return false;
        if (other.getFirmwareUpdateRole() != null && other.getFirmwareUpdateRole().equals(this.getFirmwareUpdateRole()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getRedundancyPercent() == null ^ this.getRedundancyPercent() == null)
            return false;
        if (other.getRedundancyPercent() != null && other.getRedundancyPercent().equals(this.getRedundancyPercent()) == false)
            return false;
        if (other.getFragmentSizeBytes() == null ^ this.getFragmentSizeBytes() == null)
            return false;
        if (other.getFragmentSizeBytes() != null && other.getFragmentSizeBytes().equals(this.getFragmentSizeBytes()) == false)
            return false;
        if (other.getFragmentIntervalMS() == null ^ this.getFragmentIntervalMS() == null)
            return false;
        if (other.getFragmentIntervalMS() != null && other.getFragmentIntervalMS().equals(this.getFragmentIntervalMS()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        hashCode = prime * hashCode + ((getLoRaWAN() == null) ? 0 : getLoRaWAN().hashCode());
        hashCode = prime * hashCode + ((getFirmwareUpdateImage() == null) ? 0 : getFirmwareUpdateImage().hashCode());
        hashCode = prime * hashCode + ((getFirmwareUpdateRole() == null) ? 0 : getFirmwareUpdateRole().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getRedundancyPercent() == null) ? 0 : getRedundancyPercent().hashCode());
        hashCode = prime * hashCode + ((getFragmentSizeBytes() == null) ? 0 : getFragmentSizeBytes().hashCode());
        hashCode = prime * hashCode + ((getFragmentIntervalMS() == null) ? 0 : getFragmentIntervalMS().hashCode());
        return hashCode;
    }

    @Override
    public CreateFuotaTaskRequest clone() {
        return (CreateFuotaTaskRequest) super.clone();
    }

}
