/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.Configuration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateEventConfigurationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Map<String, Configuration> eventConfigurations;

    public Map<String, Configuration> getEventConfigurations() {
        return this.eventConfigurations;
    }

    public void setEventConfigurations(Map<String, Configuration> eventConfigurations) {
        this.eventConfigurations = eventConfigurations;
    }

    public UpdateEventConfigurationsRequest withEventConfigurations(Map<String, Configuration> eventConfigurations) {
        this.setEventConfigurations(eventConfigurations);
        return this;
    }

    public UpdateEventConfigurationsRequest addEventConfigurationsEntry(String key, Configuration value) {
        if (null == this.eventConfigurations) {
            this.eventConfigurations = new HashMap<String, Configuration>();
        }
        if (this.eventConfigurations.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventConfigurations.put(key, value);
        return this;
    }

    public UpdateEventConfigurationsRequest clearEventConfigurationsEntries() {
        this.eventConfigurations = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventConfigurations() != null) {
            sb.append("EventConfigurations: ").append(this.getEventConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventConfigurationsRequest)) {
            return false;
        }
        UpdateEventConfigurationsRequest other = (UpdateEventConfigurationsRequest)obj;
        if (other.getEventConfigurations() == null ^ this.getEventConfigurations() == null) {
            return false;
        }
        return other.getEventConfigurations() == null || other.getEventConfigurations().equals(this.getEventConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventConfigurations() == null ? 0 : this.getEventConfigurations().hashCode());
        return hashCode;
    }

    public UpdateEventConfigurationsRequest clone() {
        return (UpdateEventConfigurationsRequest)super.clone();
    }
}

