/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.internetmonitor.model.Operator;
import com.amazonaws.services.internetmonitor.model.transform.FilterParameterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterParameter
implements Serializable,
Cloneable,
StructuredPojo {
    private String field;
    private String operator;
    private List<String> values;

    public void setField(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public FilterParameter withField(String field) {
        this.setField(field);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public FilterParameter withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public FilterParameter withOperator(Operator operator) {
        this.operator = operator.toString();
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public FilterParameter withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public FilterParameter withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getField() != null) {
            sb.append("Field: ").append(this.getField()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator()).append(",");
        }
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterParameter)) {
            return false;
        }
        FilterParameter other = (FilterParameter)obj;
        if (other.getField() == null ^ this.getField() == null) {
            return false;
        }
        if (other.getField() != null && !other.getField().equals(this.getField())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        if (other.getOperator() != null && !other.getOperator().equals(this.getOperator())) {
            return false;
        }
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        return other.getValues() == null || other.getValues().equals(this.getValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getField() == null ? 0 : this.getField().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        return hashCode;
    }

    public FilterParameter clone() {
        try {
            return (FilterParameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FilterParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

