/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.services.identitymanagement.model.StatusType;
import java.io.Serializable;
import java.util.Date;

public class AccessKey
implements Serializable,
Cloneable {
    private String userName;
    private String accessKeyId;
    private String status;
    private String secretAccessKey;
    private Date createDate;

    public AccessKey() {
    }

    public AccessKey(String userName, String accessKeyId, String status, String secretAccessKey) {
        this.setUserName(userName);
        this.setAccessKeyId(accessKeyId);
        this.setStatus(status);
        this.setSecretAccessKey(secretAccessKey);
    }

    public AccessKey(String userName, String accessKeyId, StatusType status, String secretAccessKey) {
        this.setUserName(userName);
        this.setAccessKeyId(accessKeyId);
        this.setStatus(status.toString());
        this.setSecretAccessKey(secretAccessKey);
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public AccessKey withUserName(String userName) {
        this.setUserName(userName);
        return this;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public AccessKey withAccessKeyId(String accessKeyId) {
        this.setAccessKeyId(accessKeyId);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AccessKey withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(StatusType status) {
        this.status = status.toString();
    }

    public AccessKey withStatus(StatusType status) {
        this.setStatus(status);
        return this;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public AccessKey withSecretAccessKey(String secretAccessKey) {
        this.setSecretAccessKey(secretAccessKey);
        return this;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public AccessKey withCreateDate(Date createDate) {
        this.setCreateDate(createDate);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserName() != null) {
            sb.append("UserName: " + this.getUserName() + ",");
        }
        if (this.getAccessKeyId() != null) {
            sb.append("AccessKeyId: " + this.getAccessKeyId() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getSecretAccessKey() != null) {
            sb.append("SecretAccessKey: " + this.getSecretAccessKey() + ",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: " + this.getCreateDate());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKey)) {
            return false;
        }
        AccessKey other = (AccessKey)obj;
        if (other.getUserName() == null ^ this.getUserName() == null) {
            return false;
        }
        if (other.getUserName() != null && !other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (other.getAccessKeyId() == null ^ this.getAccessKeyId() == null) {
            return false;
        }
        if (other.getAccessKeyId() != null && !other.getAccessKeyId().equals(this.getAccessKeyId())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getSecretAccessKey() == null ^ this.getSecretAccessKey() == null) {
            return false;
        }
        if (other.getSecretAccessKey() != null && !other.getSecretAccessKey().equals(this.getSecretAccessKey())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        return other.getCreateDate() == null || other.getCreateDate().equals(this.getCreateDate());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserName() == null ? 0 : this.getUserName().hashCode());
        hashCode = 31 * hashCode + (this.getAccessKeyId() == null ? 0 : this.getAccessKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSecretAccessKey() == null ? 0 : this.getSecretAccessKey().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        return hashCode;
    }

    public AccessKey clone() {
        try {
            return (AccessKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

