/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.Frequency;
import com.amazonaws.services.groundstation.model.FrequencyBandwidth;
import com.amazonaws.services.groundstation.model.Polarization;
import com.amazonaws.services.groundstation.model.transform.SpectrumConfigMarshaller;
import java.io.Serializable;

public class SpectrumConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private FrequencyBandwidth bandwidth;
    private Frequency centerFrequency;
    private String polarization;

    public void setBandwidth(FrequencyBandwidth bandwidth) {
        this.bandwidth = bandwidth;
    }

    public FrequencyBandwidth getBandwidth() {
        return this.bandwidth;
    }

    public SpectrumConfig withBandwidth(FrequencyBandwidth bandwidth) {
        this.setBandwidth(bandwidth);
        return this;
    }

    public void setCenterFrequency(Frequency centerFrequency) {
        this.centerFrequency = centerFrequency;
    }

    public Frequency getCenterFrequency() {
        return this.centerFrequency;
    }

    public SpectrumConfig withCenterFrequency(Frequency centerFrequency) {
        this.setCenterFrequency(centerFrequency);
        return this;
    }

    public void setPolarization(String polarization) {
        this.polarization = polarization;
    }

    public String getPolarization() {
        return this.polarization;
    }

    public SpectrumConfig withPolarization(String polarization) {
        this.setPolarization(polarization);
        return this;
    }

    public SpectrumConfig withPolarization(Polarization polarization) {
        this.polarization = polarization.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBandwidth() != null) {
            sb.append("Bandwidth: ").append(this.getBandwidth()).append(",");
        }
        if (this.getCenterFrequency() != null) {
            sb.append("CenterFrequency: ").append(this.getCenterFrequency()).append(",");
        }
        if (this.getPolarization() != null) {
            sb.append("Polarization: ").append(this.getPolarization());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpectrumConfig)) {
            return false;
        }
        SpectrumConfig other = (SpectrumConfig)obj;
        if (other.getBandwidth() == null ^ this.getBandwidth() == null) {
            return false;
        }
        if (other.getBandwidth() != null && !other.getBandwidth().equals(this.getBandwidth())) {
            return false;
        }
        if (other.getCenterFrequency() == null ^ this.getCenterFrequency() == null) {
            return false;
        }
        if (other.getCenterFrequency() != null && !other.getCenterFrequency().equals(this.getCenterFrequency())) {
            return false;
        }
        if (other.getPolarization() == null ^ this.getPolarization() == null) {
            return false;
        }
        return other.getPolarization() == null || other.getPolarization().equals(this.getPolarization());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBandwidth() == null ? 0 : this.getBandwidth().hashCode());
        hashCode = 31 * hashCode + (this.getCenterFrequency() == null ? 0 : this.getCenterFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getPolarization() == null ? 0 : this.getPolarization().hashCode());
        return hashCode;
    }

    public SpectrumConfig clone() {
        try {
            return (SpectrumConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpectrumConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

