/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.PortRange;
import com.amazonaws.services.globalaccelerator.model.transform.CustomRoutingListenerMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomRoutingListener
implements Serializable,
Cloneable,
StructuredPojo {
    private String listenerArn;
    private List<PortRange> portRanges;

    public void setListenerArn(String listenerArn) {
        this.listenerArn = listenerArn;
    }

    public String getListenerArn() {
        return this.listenerArn;
    }

    public CustomRoutingListener withListenerArn(String listenerArn) {
        this.setListenerArn(listenerArn);
        return this;
    }

    public List<PortRange> getPortRanges() {
        return this.portRanges;
    }

    public void setPortRanges(Collection<PortRange> portRanges) {
        if (portRanges == null) {
            this.portRanges = null;
            return;
        }
        this.portRanges = new ArrayList<PortRange>(portRanges);
    }

    public CustomRoutingListener withPortRanges(PortRange ... portRanges) {
        if (this.portRanges == null) {
            this.setPortRanges(new ArrayList<PortRange>(portRanges.length));
        }
        for (PortRange ele : portRanges) {
            this.portRanges.add(ele);
        }
        return this;
    }

    public CustomRoutingListener withPortRanges(Collection<PortRange> portRanges) {
        this.setPortRanges(portRanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListenerArn() != null) {
            sb.append("ListenerArn: ").append(this.getListenerArn()).append(",");
        }
        if (this.getPortRanges() != null) {
            sb.append("PortRanges: ").append(this.getPortRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomRoutingListener)) {
            return false;
        }
        CustomRoutingListener other = (CustomRoutingListener)obj;
        if (other.getListenerArn() == null ^ this.getListenerArn() == null) {
            return false;
        }
        if (other.getListenerArn() != null && !other.getListenerArn().equals(this.getListenerArn())) {
            return false;
        }
        if (other.getPortRanges() == null ^ this.getPortRanges() == null) {
            return false;
        }
        return other.getPortRanges() == null || other.getPortRanges().equals(this.getPortRanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListenerArn() == null ? 0 : this.getListenerArn().hashCode());
        hashCode = 31 * hashCode + (this.getPortRanges() == null ? 0 : this.getPortRanges().hashCode());
        return hashCode;
    }

    public CustomRoutingListener clone() {
        try {
            return (CustomRoutingListener)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CustomRoutingListenerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

