/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.transform.EvaluatedRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EvaluatedRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleId;
    private String ruleVersion;
    private String expression;
    private String expressionWithValues;
    private List<String> outcomes;
    private Boolean evaluated;
    private Boolean matched;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public EvaluatedRule withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setRuleVersion(String ruleVersion) {
        this.ruleVersion = ruleVersion;
    }

    public String getRuleVersion() {
        return this.ruleVersion;
    }

    public EvaluatedRule withRuleVersion(String ruleVersion) {
        this.setRuleVersion(ruleVersion);
        return this;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public EvaluatedRule withExpression(String expression) {
        this.setExpression(expression);
        return this;
    }

    public void setExpressionWithValues(String expressionWithValues) {
        this.expressionWithValues = expressionWithValues;
    }

    public String getExpressionWithValues() {
        return this.expressionWithValues;
    }

    public EvaluatedRule withExpressionWithValues(String expressionWithValues) {
        this.setExpressionWithValues(expressionWithValues);
        return this;
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(Collection<String> outcomes) {
        if (outcomes == null) {
            this.outcomes = null;
            return;
        }
        this.outcomes = new ArrayList<String>(outcomes);
    }

    public EvaluatedRule withOutcomes(String ... outcomes) {
        if (this.outcomes == null) {
            this.setOutcomes(new ArrayList<String>(outcomes.length));
        }
        for (String ele : outcomes) {
            this.outcomes.add(ele);
        }
        return this;
    }

    public EvaluatedRule withOutcomes(Collection<String> outcomes) {
        this.setOutcomes(outcomes);
        return this;
    }

    public void setEvaluated(Boolean evaluated) {
        this.evaluated = evaluated;
    }

    public Boolean getEvaluated() {
        return this.evaluated;
    }

    public EvaluatedRule withEvaluated(Boolean evaluated) {
        this.setEvaluated(evaluated);
        return this;
    }

    public Boolean isEvaluated() {
        return this.evaluated;
    }

    public void setMatched(Boolean matched) {
        this.matched = matched;
    }

    public Boolean getMatched() {
        return this.matched;
    }

    public EvaluatedRule withMatched(Boolean matched) {
        this.setMatched(matched);
        return this;
    }

    public Boolean isMatched() {
        return this.matched;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId()).append(",");
        }
        if (this.getRuleVersion() != null) {
            sb.append("RuleVersion: ").append(this.getRuleVersion()).append(",");
        }
        if (this.getExpression() != null) {
            sb.append("Expression: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExpressionWithValues() != null) {
            sb.append("ExpressionWithValues: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getOutcomes() != null) {
            sb.append("Outcomes: ").append(this.getOutcomes()).append(",");
        }
        if (this.getEvaluated() != null) {
            sb.append("Evaluated: ").append(this.getEvaluated()).append(",");
        }
        if (this.getMatched() != null) {
            sb.append("Matched: ").append(this.getMatched());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatedRule)) {
            return false;
        }
        EvaluatedRule other = (EvaluatedRule)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getRuleVersion() == null ^ this.getRuleVersion() == null) {
            return false;
        }
        if (other.getRuleVersion() != null && !other.getRuleVersion().equals(this.getRuleVersion())) {
            return false;
        }
        if (other.getExpression() == null ^ this.getExpression() == null) {
            return false;
        }
        if (other.getExpression() != null && !other.getExpression().equals(this.getExpression())) {
            return false;
        }
        if (other.getExpressionWithValues() == null ^ this.getExpressionWithValues() == null) {
            return false;
        }
        if (other.getExpressionWithValues() != null && !other.getExpressionWithValues().equals(this.getExpressionWithValues())) {
            return false;
        }
        if (other.getOutcomes() == null ^ this.getOutcomes() == null) {
            return false;
        }
        if (other.getOutcomes() != null && !other.getOutcomes().equals(this.getOutcomes())) {
            return false;
        }
        if (other.getEvaluated() == null ^ this.getEvaluated() == null) {
            return false;
        }
        if (other.getEvaluated() != null && !other.getEvaluated().equals(this.getEvaluated())) {
            return false;
        }
        if (other.getMatched() == null ^ this.getMatched() == null) {
            return false;
        }
        return other.getMatched() == null || other.getMatched().equals(this.getMatched());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getRuleVersion() == null ? 0 : this.getRuleVersion().hashCode());
        hashCode = 31 * hashCode + (this.getExpression() == null ? 0 : this.getExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionWithValues() == null ? 0 : this.getExpressionWithValues().hashCode());
        hashCode = 31 * hashCode + (this.getOutcomes() == null ? 0 : this.getOutcomes().hashCode());
        hashCode = 31 * hashCode + (this.getEvaluated() == null ? 0 : this.getEvaluated().hashCode());
        hashCode = 31 * hashCode + (this.getMatched() == null ? 0 : this.getMatched().hashCode());
        return hashCode;
    }

    public EvaluatedRule clone() {
        try {
            return (EvaluatedRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluatedRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

