/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ExperimentAction;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class ExperimentActionMarshaller {
    private static final MarshallingInfo<String> ACTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionId").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parameters").build();
    private static final MarshallingInfo<Map> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targets").build();
    private static final MarshallingInfo<List> STARTAFTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startAfter").build();
    private static final MarshallingInfo<StructuredPojo> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").timestampFormat("unixTimestamp").build();
    private static final ExperimentActionMarshaller instance = new ExperimentActionMarshaller();

    public static ExperimentActionMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExperimentAction experimentAction, ProtocolMarshaller protocolMarshaller) {
        if (experimentAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)experimentAction.getActionId(), ACTIONID_BINDING);
            protocolMarshaller.marshall((Object)experimentAction.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(experimentAction.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(experimentAction.getTargets(), TARGETS_BINDING);
            protocolMarshaller.marshall(experimentAction.getStartAfter(), STARTAFTER_BINDING);
            protocolMarshaller.marshall((Object)experimentAction.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)experimentAction.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)experimentAction.getEndTime(), ENDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

