/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.emrcontainers.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configurations related to encryption for the security configuration.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/EncryptionConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EncryptionConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * In-transit encryption-related input for the security configuration.
     * </p>
     */
    private InTransitEncryptionConfiguration inTransitEncryptionConfiguration;

    /**
     * <p>
     * In-transit encryption-related input for the security configuration.
     * </p>
     * 
     * @param inTransitEncryptionConfiguration
     *        In-transit encryption-related input for the security configuration.
     */

    public void setInTransitEncryptionConfiguration(InTransitEncryptionConfiguration inTransitEncryptionConfiguration) {
        this.inTransitEncryptionConfiguration = inTransitEncryptionConfiguration;
    }

    /**
     * <p>
     * In-transit encryption-related input for the security configuration.
     * </p>
     * 
     * @return In-transit encryption-related input for the security configuration.
     */

    public InTransitEncryptionConfiguration getInTransitEncryptionConfiguration() {
        return this.inTransitEncryptionConfiguration;
    }

    /**
     * <p>
     * In-transit encryption-related input for the security configuration.
     * </p>
     * 
     * @param inTransitEncryptionConfiguration
     *        In-transit encryption-related input for the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EncryptionConfiguration withInTransitEncryptionConfiguration(InTransitEncryptionConfiguration inTransitEncryptionConfiguration) {
        setInTransitEncryptionConfiguration(inTransitEncryptionConfiguration);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInTransitEncryptionConfiguration() != null)
            sb.append("InTransitEncryptionConfiguration: ").append(getInTransitEncryptionConfiguration());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EncryptionConfiguration == false)
            return false;
        EncryptionConfiguration other = (EncryptionConfiguration) obj;
        if (other.getInTransitEncryptionConfiguration() == null ^ this.getInTransitEncryptionConfiguration() == null)
            return false;
        if (other.getInTransitEncryptionConfiguration() != null
                && other.getInTransitEncryptionConfiguration().equals(this.getInTransitEncryptionConfiguration()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInTransitEncryptionConfiguration() == null) ? 0 : getInTransitEncryptionConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public EncryptionConfiguration clone() {
        try {
            return (EncryptionConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.emrcontainers.model.transform.EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
