/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RecoveryStats
implements JsonpSerializable {
    private final long currentAsSource;
    private final long currentAsTarget;
    @Nullable
    private final String throttleTime;
    private final long throttleTimeInMillis;
    public static final JsonpDeserializer<RecoveryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStats::setupRecoveryStatsDeserializer);

    private RecoveryStats(Builder builder) {
        this.currentAsSource = ApiTypeHelper.requireNonNull(builder.currentAsSource, this, "currentAsSource");
        this.currentAsTarget = ApiTypeHelper.requireNonNull(builder.currentAsTarget, this, "currentAsTarget");
        this.throttleTime = builder.throttleTime;
        this.throttleTimeInMillis = ApiTypeHelper.requireNonNull(builder.throttleTimeInMillis, this, "throttleTimeInMillis");
    }

    public static RecoveryStats of(Function<Builder, ObjectBuilder<RecoveryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long currentAsSource() {
        return this.currentAsSource;
    }

    public final long currentAsTarget() {
        return this.currentAsTarget;
    }

    @Nullable
    public final String throttleTime() {
        return this.throttleTime;
    }

    public final long throttleTimeInMillis() {
        return this.throttleTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current_as_source");
        generator.write(this.currentAsSource);
        generator.writeKey("current_as_target");
        generator.write(this.currentAsTarget);
        if (this.throttleTime != null) {
            generator.writeKey("throttle_time");
            generator.write(this.throttleTime);
        }
        generator.writeKey("throttle_time_in_millis");
        generator.write(this.throttleTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRecoveryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentAsSource, JsonpDeserializer.longDeserializer(), "current_as_source");
        op.add(Builder::currentAsTarget, JsonpDeserializer.longDeserializer(), "current_as_target");
        op.add(Builder::throttleTime, JsonpDeserializer.stringDeserializer(), "throttle_time");
        op.add(Builder::throttleTimeInMillis, JsonpDeserializer.longDeserializer(), "throttle_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RecoveryStats> {
        private Long currentAsSource;
        private Long currentAsTarget;
        @Nullable
        private String throttleTime;
        private Long throttleTimeInMillis;

        public final Builder currentAsSource(long value) {
            this.currentAsSource = value;
            return this;
        }

        public final Builder currentAsTarget(long value) {
            this.currentAsTarget = value;
            return this;
        }

        public final Builder throttleTime(@Nullable String value) {
            this.throttleTime = value;
            return this;
        }

        public final Builder throttleTimeInMillis(long value) {
            this.throttleTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RecoveryStats build() {
            this._checkSingleUse();
            return new RecoveryStats(this);
        }
    }
}

