/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ArrayCompareOpParams;
import co.elastic.clients.elasticsearch.watcher.ConditionOp;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;

@JsonpDeserializable
public class ArrayCompareCondition
implements JsonpSerializable {
    private final ConditionOp operator;
    private final ArrayCompareOpParams params;
    private final String path;
    public static final JsonpDeserializer<ArrayCompareCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayCompareCondition::setupArrayCompareConditionDeserializer);

    private ArrayCompareCondition(Builder builder) {
        this.operator = ApiTypeHelper.requireNonNull(builder.operator, this, "operator");
        this.params = ApiTypeHelper.requireNonNull(builder.params, this, "params");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
    }

    public static ArrayCompareCondition of(Function<Builder, ObjectBuilder<ArrayCompareCondition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ConditionOp operator() {
        return this.operator;
    }

    public final ArrayCompareOpParams params() {
        return this.params;
    }

    public final String path() {
        return this.path;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.operator.jsonValue());
        this.params.serialize(generator, mapper);
        generator.writeKey("path");
        generator.write(this.path);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupArrayCompareConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.operator(ConditionOp._DESERIALIZER.parse((String)name));
            builder.params(ArrayCompareOpParams._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ArrayCompareCondition> {
        private ConditionOp operator;
        private ArrayCompareOpParams params;
        private String path;

        public final Builder operator(ConditionOp value) {
            this.operator = value;
            return this;
        }

        public final Builder params(ArrayCompareOpParams value) {
            this.params = value;
            return this;
        }

        public final Builder params(Function<ArrayCompareOpParams.Builder, ObjectBuilder<ArrayCompareOpParams>> fn) {
            return this.params(fn.apply(new ArrayCompareOpParams.Builder()).build());
        }

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ArrayCompareCondition build() {
            this._checkSingleUse();
            return new ArrayCompareCondition(this);
        }
    }
}

