/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetCategoriesResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetCategoriesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String categoryId;
    @Nullable
    private final Integer from;
    private final String jobId;
    @Nullable
    private final Page page;
    @Nullable
    private final String partitionFieldValue;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GetCategoriesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetCategoriesRequest::setupGetCategoriesRequestDeserializer);
    public static final Endpoint<GetCategoriesRequest, GetCategoriesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetCategoriesRequest, GetCategoriesResponse>("es/ml.get_categories", request -> "POST", request -> {
        boolean _categoryId = true;
        int _jobId = 2;
        int propsSet = 0;
        if (request.categoryId() != null) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/categories");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.categoryId, buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/categories");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.partitionFieldValue != null) {
            params.put("partition_field_value", request.partitionFieldValue);
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetCategoriesResponse._DESERIALIZER);

    private GetCategoriesRequest(Builder builder) {
        this.categoryId = builder.categoryId;
        this.from = builder.from;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.page = builder.page;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.size = builder.size;
    }

    public static GetCategoriesRequest of(Function<Builder, ObjectBuilder<GetCategoriesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String categoryId() {
        return this.categoryId;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Page page() {
        return this.page;
    }

    @Nullable
    public final String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
    }

    protected static void setupGetCategoriesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::page, Page._DESERIALIZER, "page");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetCategoriesRequest> {
        @Nullable
        private String categoryId;
        @Nullable
        private Integer from;
        private String jobId;
        @Nullable
        private Page page;
        @Nullable
        private String partitionFieldValue;
        @Nullable
        private Integer size;

        public final Builder categoryId(@Nullable String value) {
            this.categoryId = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public final Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public final Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetCategoriesRequest build() {
            this._checkSingleUse();
            return new GetCategoriesRequest(this);
        }
    }
}

