/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.rollover;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class IndexRolloverMapping
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<IndexRolloverMapping> _DESERIALIZER = JsonpDeserializer.lazy(IndexRolloverMapping::buildIndexRolloverMappingDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private IndexRolloverMapping(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private IndexRolloverMapping(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static IndexRolloverMapping of(Function<Builder, ObjectBuilder<IndexRolloverMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isByType() {
        return this._kind == Kind.ByType;
    }

    public Map<String, TypeMapping> byType() {
        return (Map)TaggedUnionUtils.get(this, Kind.ByType);
    }

    public boolean isSingle() {
        return this._kind == Kind.Single;
    }

    public TypeMapping single() {
        return (TypeMapping)TaggedUnionUtils.get(this, Kind.Single);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case ByType: {
                    generator.writeStartObject();
                    for (Map.Entry item0 : ((Map)this._value).entrySet()) {
                        generator.writeKey((String)item0.getKey());
                        ((TypeMapping)item0.getValue()).serialize(generator, mapper);
                    }
                    generator.writeEnd();
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<IndexRolloverMapping> buildIndexRolloverMappingDeserializer() {
        return new UnionDeserializer.Builder<IndexRolloverMapping, Kind, Object>(IndexRolloverMapping::new, false).addMember(Kind.ByType, JsonpDeserializer.stringMapDeserializer(TypeMapping._DESERIALIZER)).addMember(Kind.Single, TypeMapping._DESERIALIZER).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexRolloverMapping> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<IndexRolloverMapping> byType(Map<String, TypeMapping> v) {
            this._kind = Kind.ByType;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IndexRolloverMapping> single(TypeMapping v) {
            this._kind = Kind.Single;
            this._value = v;
            return this;
        }

        public ObjectBuilder<IndexRolloverMapping> single(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.single(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        public IndexRolloverMapping build() {
            this._checkSingleUse();
            return new IndexRolloverMapping(this);
        }
    }

    public static enum Kind {
        ByType,
        Single;

    }
}

