/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GetStats
implements JsonpSerializable {
    private final long current;
    @Nullable
    private final String existsTime;
    private final long existsTimeInMillis;
    private final long existsTotal;
    @Nullable
    private final String missingTime;
    private final long missingTimeInMillis;
    private final long missingTotal;
    @Nullable
    private final String time;
    private final long timeInMillis;
    private final long total;
    public static final JsonpDeserializer<GetStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStats::setupGetStatsDeserializer);

    private GetStats(Builder builder) {
        this.current = ApiTypeHelper.requireNonNull(builder.current, this, "current");
        this.existsTime = builder.existsTime;
        this.existsTimeInMillis = ApiTypeHelper.requireNonNull(builder.existsTimeInMillis, this, "existsTimeInMillis");
        this.existsTotal = ApiTypeHelper.requireNonNull(builder.existsTotal, this, "existsTotal");
        this.missingTime = builder.missingTime;
        this.missingTimeInMillis = ApiTypeHelper.requireNonNull(builder.missingTimeInMillis, this, "missingTimeInMillis");
        this.missingTotal = ApiTypeHelper.requireNonNull(builder.missingTotal, this, "missingTotal");
        this.time = builder.time;
        this.timeInMillis = ApiTypeHelper.requireNonNull(builder.timeInMillis, this, "timeInMillis");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static GetStats of(Function<Builder, ObjectBuilder<GetStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long current() {
        return this.current;
    }

    @Nullable
    public final String existsTime() {
        return this.existsTime;
    }

    public final long existsTimeInMillis() {
        return this.existsTimeInMillis;
    }

    public final long existsTotal() {
        return this.existsTotal;
    }

    @Nullable
    public final String missingTime() {
        return this.missingTime;
    }

    public final long missingTimeInMillis() {
        return this.missingTimeInMillis;
    }

    public final long missingTotal() {
        return this.missingTotal;
    }

    @Nullable
    public final String time() {
        return this.time;
    }

    public final long timeInMillis() {
        return this.timeInMillis;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("current");
        generator.write(this.current);
        if (this.existsTime != null) {
            generator.writeKey("exists_time");
            generator.write(this.existsTime);
        }
        generator.writeKey("exists_time_in_millis");
        generator.write(this.existsTimeInMillis);
        generator.writeKey("exists_total");
        generator.write(this.existsTotal);
        if (this.missingTime != null) {
            generator.writeKey("missing_time");
            generator.write(this.missingTime);
        }
        generator.writeKey("missing_time_in_millis");
        generator.write(this.missingTimeInMillis);
        generator.writeKey("missing_total");
        generator.write(this.missingTotal);
        if (this.time != null) {
            generator.writeKey("time");
            generator.write(this.time);
        }
        generator.writeKey("time_in_millis");
        generator.write(this.timeInMillis);
        generator.writeKey("total");
        generator.write(this.total);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::existsTime, JsonpDeserializer.stringDeserializer(), "exists_time");
        op.add(Builder::existsTimeInMillis, JsonpDeserializer.longDeserializer(), "exists_time_in_millis");
        op.add(Builder::existsTotal, JsonpDeserializer.longDeserializer(), "exists_total");
        op.add(Builder::missingTime, JsonpDeserializer.stringDeserializer(), "missing_time");
        op.add(Builder::missingTimeInMillis, JsonpDeserializer.longDeserializer(), "missing_time_in_millis");
        op.add(Builder::missingTotal, JsonpDeserializer.longDeserializer(), "missing_total");
        op.add(Builder::time, JsonpDeserializer.stringDeserializer(), "time");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetStats> {
        private Long current;
        @Nullable
        private String existsTime;
        private Long existsTimeInMillis;
        private Long existsTotal;
        @Nullable
        private String missingTime;
        private Long missingTimeInMillis;
        private Long missingTotal;
        @Nullable
        private String time;
        private Long timeInMillis;
        private Long total;

        public final Builder current(long value) {
            this.current = value;
            return this;
        }

        public final Builder existsTime(@Nullable String value) {
            this.existsTime = value;
            return this;
        }

        public final Builder existsTimeInMillis(long value) {
            this.existsTimeInMillis = value;
            return this;
        }

        public final Builder existsTotal(long value) {
            this.existsTotal = value;
            return this;
        }

        public final Builder missingTime(@Nullable String value) {
            this.missingTime = value;
            return this;
        }

        public final Builder missingTimeInMillis(long value) {
            this.missingTimeInMillis = value;
            return this;
        }

        public final Builder missingTotal(long value) {
            this.missingTotal = value;
            return this;
        }

        public final Builder time(@Nullable String value) {
            this.time = value;
            return this;
        }

        public final Builder timeInMillis(long value) {
            this.timeInMillis = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetStats build() {
            this._checkSingleUse();
            return new GetStats(this);
        }
    }
}

