/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry;

import cn.ponfee.scheduler.common.base.model.Result;
import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.common.util.Jsons;
import cn.ponfee.scheduler.core.base.Server;
import cn.ponfee.scheduler.registry.Discovery;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.IntMath;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DiscoveryRestTemplate<D extends Server> {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryRestTemplate.class);
    public static final Type RESULT_STRING = new ParameterizedTypeReference<Result<String>>(){}.getType();
    public static final Type RESULT_BOOLEAN = new ParameterizedTypeReference<Result<Boolean>>(){}.getType();
    public static final Type RESULT_VOID = new ParameterizedTypeReference<Result<Void>>(){}.getType();
    public static final Object[] EMPTY = new Object[0];
    private static final Set<HttpMethod> QUERY_PARAMS = ImmutableSet.of((Object)HttpMethod.GET, (Object)HttpMethod.DELETE, (Object)HttpMethod.HEAD, (Object)HttpMethod.OPTIONS);
    private final RestTemplate restTemplate;
    private final Discovery<D> discoveryServer;
    private final int maxRetryTimes;

    private DiscoveryRestTemplate(int connectTimeout, int readTimeout, ObjectMapper objectMapper, Discovery<D> discoveryServer, int maxRetryTimes) {
        MappingJackson2HttpMessageConverter httpMessageConverter = new MappingJackson2HttpMessageConverter();
        httpMessageConverter.setObjectMapper(objectMapper);
        httpMessageConverter.setSupportedMediaTypes(Collects.concat((List)httpMessageConverter.getSupportedMediaTypes(), (Object[])new MediaType[]{MediaType.TEXT_PLAIN}));
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(readTimeout);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setMessageConverters(Arrays.asList(new ByteArrayHttpMessageConverter(), new StringHttpMessageConverter(StandardCharsets.UTF_8), new ResourceHttpMessageConverter(), new SourceHttpMessageConverter(), new FormHttpMessageConverter(), httpMessageConverter));
        this.restTemplate = restTemplate;
        this.discoveryServer = discoveryServer;
        this.maxRetryTimes = maxRetryTimes;
    }

    public <T> T execute(String path, HttpMethod httpMethod, Type returnType, Object ... arguments) throws Exception {
        return this.doExecute(null, path, httpMethod, returnType, arguments);
    }

    public <T> T execute(String group, String path, HttpMethod httpMethod, Type returnType, Object ... arguments) throws Exception {
        return this.doExecute(group, path, httpMethod, returnType, arguments);
    }

    private <T> T doExecute(String group, String path, HttpMethod httpMethod, Type returnType, Object ... arguments) throws Exception {
        List<D> servers = this.discoveryServer.getDiscoveredServers(group);
        if (CollectionUtils.isEmpty(servers)) {
            throw new IllegalStateException("Not found available " + this.discoveryServer.discoveryRole().name());
        }
        int serverNumber = servers.size();
        int start = ThreadLocalRandom.current().nextInt(serverNumber);
        int n = Math.min(serverNumber, this.maxRetryTimes) + 1;
        for (int i = 0; i < n; ++i) {
            Server server = (Server)servers.get((start + i) % serverNumber);
            String url = String.format("http://%s:%d/%s", server.getHost(), server.getPort(), path);
            try {
                HttpEntity httpEntity;
                URI uri;
                if (QUERY_PARAMS.contains(httpMethod)) {
                    UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
                    if (ArrayUtils.isNotEmpty((Object[])arguments)) {
                        builder.queryParams(DiscoveryRestTemplate.buildQueryParams(arguments));
                    }
                    uri = builder.build().encode().toUri();
                    httpEntity = null;
                } else {
                    uri = this.restTemplate.getUriTemplateHandler().expand(url, EMPTY);
                    httpEntity = ArrayUtils.isEmpty((Object[])arguments) ? null : new HttpEntity((Object)arguments);
                }
                RequestCallback requestCallback = this.restTemplate.httpEntityCallback((Object)httpEntity, returnType);
                ResponseExtractor responseExtractor = this.restTemplate.responseEntityExtractor(returnType);
                return (T)((ResponseEntity)this.restTemplate.execute(uri, httpMethod, requestCallback, responseExtractor)).getBody();
            }
            catch (Exception e) {
                if (!(e instanceof ResourceAccessException) && !DiscoveryRestTemplate.is5xxServerError(e)) {
                    LOG.error("Invoked http error, url: " + url + ", req: " + Jsons.toJson((Object)arguments), (Throwable)e);
                    throw e;
                }
                LOG.error("Invoked http fail, url: " + url + ", req: " + Jsons.toJson((Object)arguments), (Throwable)e);
                Thread.sleep(300L * (long)IntMath.pow((int)(i + 1), (int)2));
                continue;
            }
        }
        throw new IllegalStateException("Invoke http retried failed: " + path + ", " + Jsons.toJson((Object)arguments));
    }

    public Discovery<D> getDiscoveryServer() {
        return this.discoveryServer;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    private static MultiValueMap<String, String> buildQueryParams(Object[] arguments) {
        if (ArrayUtils.isEmpty((Object[])arguments)) {
            return null;
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap(arguments.length << 1);
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            params.add((Object)("args[" + i + "]"), (Object)Jsons.toJson((Object)arguments[i]));
        }
        return params;
    }

    private static boolean is5xxServerError(Exception e) {
        if (!(e instanceof HttpStatusCodeException)) {
            return false;
        }
        return ((HttpStatusCodeException)e).getStatusCode().is5xxServerError();
    }

    public static <S extends Server> DiscoveryRestTemplateBuilder<S> builder() {
        return new DiscoveryRestTemplateBuilder();
    }

    public static class DiscoveryRestTemplateBuilder<S extends Server> {
        private int connectTimeout;
        private int readTimeout;
        private ObjectMapper objectMapper;
        private Discovery<S> discoveryServer;
        private int maxRetryTimes;

        public DiscoveryRestTemplateBuilder<S> connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public DiscoveryRestTemplateBuilder<S> readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public DiscoveryRestTemplateBuilder<S> objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public DiscoveryRestTemplateBuilder<S> discoveryServer(Discovery<S> discoveryServer) {
            this.discoveryServer = discoveryServer;
            return this;
        }

        public DiscoveryRestTemplateBuilder<S> maxRetryTimes(int maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public DiscoveryRestTemplate<S> build() {
            return new DiscoveryRestTemplate(this.connectTimeout, this.readTimeout, this.objectMapper, this.discoveryServer, this.maxRetryTimes);
        }
    }
}

