/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry;

import cn.ponfee.scheduler.common.util.Collects;
import cn.ponfee.scheduler.registry.DiscoveryRestTemplate;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMapping;

public class DiscoveryRestProxy {
    public static <T> T create(Class<T> interfaceType, DiscoveryRestTemplate<?> discoveryRestTemplate) {
        String prefixPath = DiscoveryRestProxy.parsePath((RequestMapping)AnnotationUtils.findAnnotation(interfaceType, RequestMapping.class));
        RestInvocationHandler invocationHandler = new RestInvocationHandler(discoveryRestTemplate, prefixPath);
        return (T)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, (InvocationHandler)invocationHandler);
    }

    private static String parsePath(RequestMapping mapping) {
        String path;
        if (mapping == null || StringUtils.isEmpty((CharSequence)(path = (String)Collects.get((Object[])mapping.path(), (int)0)))) {
            return "";
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static class Request {
        private final String path;
        private final HttpMethod httpMethod;

        private Request(String path, HttpMethod httpMethod) {
            this.path = path;
            this.httpMethod = httpMethod;
        }
    }

    private static class RestInvocationHandler
    implements InvocationHandler {
        private static final Map<Method, Request> REQUEST_CACHE = new ConcurrentHashMap<Method, Request>();
        private static final Request INVALID_REQUEST = new Request(null, null);
        private final DiscoveryRestTemplate<?> discoveryRestTemplate;
        private final String prefixPath;

        private RestInvocationHandler(DiscoveryRestTemplate<?> discoveryRestTemplate, String prefixPath) {
            this.discoveryRestTemplate = discoveryRestTemplate;
            this.prefixPath = prefixPath;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Request request = RestInvocationHandler.getRequest(this.prefixPath, method);
            return this.discoveryRestTemplate.execute(request.path, request.httpMethod, method.getGenericReturnType(), args);
        }

        private static Request getRequest(String prefixPath, Method method) {
            Request request = REQUEST_CACHE.computeIfAbsent(method, key -> {
                String fullPath;
                RequestMapping mapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)key, RequestMapping.class);
                if (ArrayUtils.isEmpty((Object[])mapping.method())) {
                    return INVALID_REQUEST;
                }
                String suffixPath = DiscoveryRestProxy.parsePath(mapping);
                if (prefixPath.isEmpty()) {
                    fullPath = suffixPath.isEmpty() ? null : suffixPath;
                } else {
                    String string = fullPath = suffixPath.isEmpty() ? prefixPath : prefixPath + "/" + suffixPath;
                }
                if (fullPath == null) {
                    return INVALID_REQUEST;
                }
                return Arrays.stream(mapping.method()).filter(Objects::nonNull).map(Enum::name).map(HttpMethod::valueOf).map(httpMethod -> new Request(fullPath, (HttpMethod)httpMethod)).findAny().orElse(INVALID_REQUEST);
            });
            if (request == INVALID_REQUEST) {
                throw new UnsupportedOperationException("Illegal defined method: " + method);
            }
            return request;
        }
    }
}

