/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class URLCodes {
    public static String encodeURI(String url) {
        return URLCodes.encodeURI(url, "UTF-8");
    }

    public static String encodeURI(String url, String charset) {
        if (url == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(url.length() * 3 / 2);
        int n = url.length();
        for (int i = 0; i < n; ++i) {
            byte[] b;
            char c = url.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                builder.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes(charset);
            }
            catch (Exception ex) {
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                builder.append('%').append(Integer.toHexString(k).toUpperCase());
            }
        }
        return builder.toString();
    }

    public static String decodeURI(String url) {
        return URLCodes.decodeURI(url, "UTF-8");
    }

    public static String decodeURI(String url, String charset) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeURIComponent(String url) {
        return URLCodes.encodeURIComponent(url, "UTF-8");
    }

    public static String encodeURIComponent(String url, String charset) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String decodeURIComponent(String url) {
        return URLCodes.decodeURI(url, "UTF-8");
    }

    public static String decodeURIComponent(String url, String charset) {
        return URLCodes.decodeURI(url, charset);
    }
}

