/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base.exception;

import cn.ponfee.scheduler.common.base.exception.CheckedThrowing;
import cn.ponfee.scheduler.common.util.ClassUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Throwables {
    private static final Logger LOG = LoggerFactory.getLogger(Throwables.class);

    public static String getRootCauseStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return ExceptionUtils.getStackTrace((Throwable)throwable);
    }

    public static String getRootCauseMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        for (int i = list.size() - 1; i >= 0; --i) {
            String message = ((Throwable)list.get(i)).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            return "error: " + message;
        }
        return "error: <" + ClassUtils.getName(throwable.getClass()) + ">";
    }

    public static <T extends Throwable> void caught(CheckedThrowing.ThrowingRunnable<T> runnable) {
        block2: {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                if (!(t instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
    }
}

