/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base;

import cn.ponfee.scheduler.common.util.Collects;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.springframework.util.Assert;

public class DoubleListViewer<E>
implements List<E>,
RandomAccess {
    private final Collection<List<E>> list;
    private final int size;

    public DoubleListViewer(Collection<List<E>> list) {
        Assert.notNull(list, (String)"Origin list cannot be null.");
        this.list = list;
        this.size = list.stream().mapToInt(e -> e == null ? 0 : e.size()).sum();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.list.stream().filter(Objects::nonNull).flatMap(Collection::stream).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.stream().filter(Objects::nonNull).flatMap(Collection::stream).toArray((int length) -> Collects.newArray(a.getClass(), length));
    }

    @Override
    public E get(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"Index must greater than zero.");
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        int count = 0;
        for (List<E> sub : this.list) {
            if (sub == null || sub.isEmpty()) continue;
            if (index >= count + sub.size()) {
                count += sub.size();
                continue;
            }
            return sub.get(index - count);
        }
        throw new IllegalStateException();
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            for (List<E> sub : this.list) {
                if (sub == null || sub.isEmpty()) continue;
                for (E e : sub) {
                    if (e == null) {
                        return index;
                    }
                    ++index;
                }
            }
        } else {
            for (List<E> sub : this.list) {
                if (sub == null || sub.isEmpty()) continue;
                for (E e : sub) {
                    if (o.equals(e)) {
                        return index;
                    }
                    ++index;
                }
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.size() - 1;
        if (o == null) {
            for (List<E> sub : this.list) {
                if (sub == null || sub.isEmpty()) continue;
                for (int i = sub.size() - 1; i >= 0; --i) {
                    if (sub.get(i) == null) {
                        return index;
                    }
                    --index;
                }
            }
        } else {
            for (List<E> sub : this.list) {
                if (sub == null || sub.isEmpty()) continue;
                for (int i = sub.size() - 1; i >= 0; --i) {
                    if (o.equals(sub.get(i))) {
                        return index;
                    }
                    --index;
                }
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableIterator(0, this.size());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new UnmodifiableListIterator(0, this.size());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new UnmodifiableListIterator(index, this.size());
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        Iterator<E> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (E e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator<E> a = this.listIterator();
        ListIterator b = ((List)o).listIterator();
        while (a.hasNext() && b.hasNext()) {
            if (Objects.equals(a.next(), b.next())) continue;
            return false;
        }
        return !a.hasNext() && !b.hasNext();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    private class UnmodifiableIterator
    implements Iterator<E> {
        protected int position;
        protected final int end;

        UnmodifiableIterator(int position, int end) {
            this.position = position;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return !DoubleListViewer.this.isEmpty() && this.position < this.end;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return DoubleListViewer.this.get(this.position++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator<E> {
        UnmodifiableListIterator(int position, int end) {
            super(position, end);
        }

        @Override
        public boolean hasPrevious() {
            return !DoubleListViewer.this.isEmpty() && this.position > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return DoubleListViewer.this.get(--this.position);
        }

        @Override
        public int nextIndex() {
            return this.position;
        }

        @Override
        public int previousIndex() {
            return this.position - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

