/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jpa.WikittyJPAUtil;

public class WikittyExtensionStorageJPA
implements WikittyExtensionStorage {
    private static Log log = LogFactory.getLog(WikittyExtensionStorageJPA.class);
    @PersistenceUnit
    protected EntityManagerFactory entityManagerFactory;
    protected Map<String, String> lastVersion = null;

    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) throws WikittyException {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        for (WikittyExtension ext : extensions) {
            String extLastVersion;
            String extId = ext.getId();
            String extName = ext.getName();
            String extVersion = ext.getVersion();
            if (WikittyUtil.versionGreaterThan((String)extVersion, (String)(extLastVersion = this.getLastVersion(transaction, extName)))) {
                entityManager.persist((Object)ext);
                this.getLastVersion(transaction).put(extName, extVersion);
                continue;
            }
            if (WikittyUtil.versionEquals((String)extVersion, (String)extLastVersion)) continue;
            throw new WikittyException(String.format("Your extension '%s' is obsolete", extId));
        }
        UpdateResponse result = new UpdateResponse();
        return result;
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        WikittyExtension extensionEntity = (WikittyExtension)entityManager.find(WikittyExtension.class, (Object)id);
        boolean result = extensionEntity != null;
        return result;
    }

    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Query query = entityManager.createQuery("SELECT we FROM WikittyExtension we");
        List extensions = query.getResultList();
        ArrayList<String> result = new ArrayList<String>();
        for (WikittyExtension extension : extensions) {
            String name = extension.getName();
            String version = extension.getVersion();
            String id = WikittyExtension.computeId((String)name, (String)version);
            result.add(id);
        }
        return result;
    }

    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Query query = entityManager.createQuery("SELECT we FROM WikittyExtension we where requires=:extensionName");
        query.setParameter("extensionName", (Object)extensionName);
        List extensions = query.getResultList();
        ArrayList<String> result = new ArrayList<String>();
        for (WikittyExtension extension : extensions) {
            String name = extension.getName();
            String version = extension.getVersion();
            String id = WikittyExtension.computeId((String)name, (String)version);
            result.add(id);
        }
        return result;
    }

    public String getLastVersion(WikittyTransaction transaction, String extName) {
        String result = this.getLastVersion(transaction).get(extName);
        log.debug((Object)("LastVersion=" + result + " for " + extName));
        return result;
    }

    protected Map<String, String> getLastVersion(WikittyTransaction transaction) {
        if (this.lastVersion == null) {
            this.lastVersion = new HashMap<String, String>();
            EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
            Query query = entityManager.createQuery("SELECT we FROM WikittyExtension we");
            List results = query.getResultList();
            for (WikittyExtension extensionEntity : results) {
                String name = extensionEntity.getName();
                String version = extensionEntity.getVersion();
                String prevVersion = this.lastVersion.get(name);
                if (prevVersion != null && !WikittyUtil.versionGreaterThan((String)version, (String)prevVersion)) continue;
                this.lastVersion.put(name, version);
            }
        }
        return this.lastVersion;
    }

    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        EntityManager entityManager = WikittyJPAUtil.getEntityManager(this.entityManagerFactory, transaction);
        Query query = entityManager.createQuery("SELECT we FROM WikittyExtension we where name=:name and version=:version");
        query.setParameter("name", (Object)name);
        query.setParameter("version", (Object)version);
        WikittyExtension extension = (WikittyExtension)query.getSingleResult();
        if (extension == null) {
            log.debug((Object)"Extension not found");
            return null;
        }
        log.debug((Object)("Extension restored=" + extension));
        return extension;
    }

    public void clear(WikittyTransaction transaction) {
    }
}

