/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.jms.WikittyActionMessage;
import org.sharengo.wikitty.jms.WikittyJMSUtil;

public class WikittyExtensionStorageJMS
implements WikittyExtensionStorage {
    protected final XATopicConnectionFactory connectionFactory;
    protected final Topic topic = new ActiveMQTopic("WikittyExtensionStorageTopic");
    protected final XATopicConnection topicConnection;
    protected final XATopicSession topicSession;
    protected final TopicPublisher topicPublisher;

    public WikittyExtensionStorageJMS(Properties properties) throws NamingException, JMSException {
        String provider = properties.getProperty("java.naming.provider.url");
        this.connectionFactory = new ActiveMQXAConnectionFactory(provider);
        this.topicConnection = this.connectionFactory.createXATopicConnection();
        this.topicSession = this.topicConnection.createXATopicSession();
        this.topicPublisher = this.topicSession.getTopicSession().createPublisher(this.topic);
    }

    public void close() throws JMSException {
        this.topicConnection.close();
    }

    protected void finalize() throws Throwable {
        this.topicConnection.close();
    }

    public UpdateResponse store(WikittyTransaction transaction, Collection<WikittyExtension> extensions) {
        try {
            WikittyJMSUtil.addXAResource(transaction, this.topicSession);
            WikittyActionMessage message = new WikittyActionMessage();
            message.setAction("store");
            message.addParameter("extensions", new ArrayList<WikittyExtension>(extensions));
            ObjectMessage sendMessage = WikittyActionMessage.createSendMessage(message);
            this.topicPublisher.publish((Message)sendMessage);
            UpdateResponse result = new UpdateResponse();
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException("Error in WikittyStorageJMS", eee);
        }
    }

    public void clear(WikittyTransaction transaction) {
        try {
            WikittyJMSUtil.addXAResource(transaction, this.topicSession);
            WikittyActionMessage message = new WikittyActionMessage();
            message.setAction("clear");
            ObjectMessage sendMessage = WikittyActionMessage.createSendMessage(message);
            this.topicPublisher.publish((Message)sendMessage);
        }
        catch (Exception eee) {
            throw new WikittyException("Error in WikittyStorageJMS", eee);
        }
    }

    public boolean exists(WikittyTransaction transaction, String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<String> getAllExtensionIds(WikittyTransaction transaction) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<String> getAllExtensionsRequires(WikittyTransaction transaction, String extensionName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLastVersion(WikittyTransaction transaction, String extName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public WikittyExtension restore(WikittyTransaction transaction, String name, String version) throws WikittyException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

