/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.io.Serializable;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class WikittyActionMessage {
    protected HashMap<String, Serializable> parameters = new HashMap();
    protected String action;

    public void setAction(String action) throws JMSException {
        this.action = action;
    }

    public String getAction() throws JMSException {
        return this.action;
    }

    public void addParameter(String name, Serializable value) {
        this.parameters.put(name, value);
    }

    public Serializable getParameter(String name) {
        Serializable result = this.parameters.get(name);
        return result;
    }

    public static ObjectMessage createSendMessage(WikittyActionMessage actionMessage) throws JMSException {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setStringProperty("action", actionMessage.action);
        message.setObject(actionMessage.parameters);
        return message;
    }

    public static WikittyActionMessage createReceiveMessage(ObjectMessage message) throws JMSException {
        WikittyActionMessage actionMessage = new WikittyActionMessage();
        actionMessage.action = message.getStringProperty("action");
        actionMessage.parameters = (HashMap)message.getObject();
        return actionMessage;
    }
}

